/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.MessengerReceiver;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.repo.DbHelper;
import com.siggytech.utils.communication.repo.MessageRaw;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONObject;

public class WebSocketChatService
extends Service {
    public String TAG = WebSocketChatService.class.getSimpleName();
    public static final String MESSAGE_CHAT = "messageChat";
    private OkHttpClient messengerClient;
    private WebSocket webSocket;
    private String name;
    private String imei;
    private String idGroup;
    private String apiKey;
    private DbHelper dbHelper;

    public void onCreate() {
        super.onCreate();
        Utils.traces("WebSocketChatService onCreate");
        this.dbHelper = new DbHelper((Context)this);
        if (Build.VERSION.SDK_INT >= 26) {
            this.startMyOwnForeground();
        } else {
            this.startForeground(Conf.COMM_NOTIFICATION_FOREGROUND_ID, new Notification());
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        try {
            Bundle extras = intent.getExtras();
            if (extras != null) {
                this.name = extras.getString("name");
                this.idGroup = String.valueOf(extras.getLong("idGroup"));
                this.imei = extras.getString("imei");
                this.apiKey = extras.getString("apiKey");
                new Thread(this::messengerWebSocketConnection).start();
            }
        }
        catch (Exception ex) {
            Log.d((String)"intent.getExtras", (String)("Error: " + ex.getMessage()));
        }
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        super.onDestroy();
        try {
            if (this.webSocket != null) {
                this.webSocket.close(1000, "onDestroy");
            }
        }
        catch (Exception e) {
            Utils.traces("WebSocketChatService onDestroy Ex: " + Utils.exceptionToString(e));
        }
        try {
            if (this.dbHelper != null) {
                this.dbHelper.close();
            }
        }
        catch (Exception e) {
            Utils.traces("WebSocketChatService onDestroy Ex: " + Utils.exceptionToString(e));
        }
        Utils.traces("WebSocketChatService onDestroy");
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.stopSelf();
    }

    @RequiresApi(api=26)
    private void startMyOwnForeground() {
        NotificationChannel chan = new NotificationChannel(Conf.COMM_NOTIFICATION_CHANNEL_ID, (CharSequence)Conf.COMM_NOTIFICATION_CHANNEL_NAME, 0);
        chan.setLightColor(-16776961);
        chan.setLockscreenVisibility(0);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        assert (manager != null);
        manager.createNotificationChannel(chan);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder((Context)this, Conf.COMM_NOTIFICATION_CHANNEL_ID);
        Notification notification = notificationBuilder.setOngoing(true).setSmallIcon(R.drawable.ic_s_notification).setContentTitle((CharSequence)Conf.COMM_NOTIFICATION_CONTENT_TITLE).setPriority(1).setCategory("service").build();
        this.startForeground(Conf.COMM_NOTIFICATION_FOREGROUND_ID, notification);
    }

    private void messengerWebSocketConnection() {
        try {
            this.messengerClient = new OkHttpClient();
            String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_CHAT_PORT + "?imei=" + this.imei + "&groupId=" + this.idGroup + "&API_KEY=" + this.apiKey + "&clientName=" + this.name;
            Log.e((String)this.TAG, (String)url);
            Request requestCoinPrice = new Request.Builder().url(url).build();
            WebSocketListener webSocketListenerMessenger = new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    Utils.traces("messengerWebSocketConnection onOpen");
                }

                public void onMessage(WebSocket webSocket, String text) {
                    try {
                        long id;
                        Utils.traces("messengerWebSocketConnection onMessage");
                        MessageRaw messageRaw = new MessageRaw();
                        JSONObject jObject = new JSONObject(text);
                        messageRaw.setIdGroup(new JSONObject(jObject.getString("data")).getString("idGroupFrom"));
                        messageRaw.setFrom(new JSONObject(jObject.getString("data")).getString("from"));
                        messageRaw.setMessage(new JSONObject(jObject.getString("data")).getString("text"));
                        messageRaw.setDate(Utils.getStringDate());
                        messageRaw.setMine(0);
                        messageRaw.setUserKey(WebSocketChatService.this.apiKey);
                        if (WebSocketChatService.this.dbHelper == null) {
                            WebSocketChatService.this.dbHelper = new DbHelper((Context)WebSocketChatService.this);
                        }
                        if ((id = WebSocketChatService.this.dbHelper.insertMessage(messageRaw)) == -1L) {
                            Utils.traces("messengerWebSocketConnection onMessage error on bd insert");
                        }
                        Intent intent = new Intent((Context)WebSocketChatService.this, MessengerReceiver.class);
                        intent.putExtra(WebSocketChatService.MESSAGE_CHAT, text);
                        WebSocketChatService.this.sendBroadcast(intent);
                    }
                    catch (Exception ex) {
                        Utils.traces("messengerWebSocketConnection onMessage: " + Utils.exceptionToString(ex));
                    }
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    try {
                        Log.e((String)WebSocketChatService.this.TAG, (String)("MESSAGE bytes: " + bytes.hex()));
                    }
                    catch (Exception ex) {
                        System.out.print(ex.getMessage());
                    }
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    webSocket.close(1000, null);
                    webSocket.cancel();
                    Utils.traces("messengerWebSocketConnection onClosing code:" + code + " reason: " + reason);
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    Utils.traces("messengerWebSocketConnection onClosed code:" + code + " reason: " + reason);
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    WebSocketChatService.this.messengerWebSocketConnection();
                }
            };
            this.webSocket = this.messengerClient.newWebSocket(requestCoinPrice, webSocketListenerMessenger);
            this.messengerClient.dispatcher().executorService().shutdown();
        }
        catch (Exception e) {
            Utils.traces("messengerWebSocketConnection catch: " + Utils.exceptionToString(e));
        }
    }
}

