/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.cardview.widget.CardView;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.FilePath;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Utils;
import java.io.File;

public class UtilActivity
extends AppCompatActivity {
    private static final String TAG = UtilActivity.class.getSimpleName();
    private static final int ACTIVITY_START_CAMARA_APP = 0;
    Uri outputFileUri;
    Context context = this;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(1);
        this.setContentView(R.layout.activity_util);
        System.out.println("Package name: " + this.getApplicationContext().getPackageName());
        if (this.getWindow() != null) {
            this.getWindow().setBackgroundDrawableResource(17170445);
            this.getWindow().setFlags(32, 32);
            this.getWindow().setFlags(262144, 262144);
        }
        ImageView ivCamera = (ImageView)this.findViewById(R.id.ivCamera);
        ivCamera.setColorFilter(Conf.CHAT_COLOR_COMPONENTS);
        ImageView ivPhotoVideo = (ImageView)this.findViewById(R.id.ivPhotoVideo);
        ivPhotoVideo.setColorFilter(Conf.CHAT_COLOR_COMPONENTS);
        TextView tvCancel = (TextView)this.findViewById(R.id.tvCancel);
        tvCancel.setTextColor(Conf.CHAT_COLOR_COMPONENTS);
        LinearLayout lnCamera = (LinearLayout)this.findViewById(R.id.lnCamera);
        LinearLayout lnPhotoVideo = (LinearLayout)this.findViewById(R.id.lnPhotoVideo);
        LinearLayout lnCancel = (LinearLayout)this.findViewById(R.id.lnCancel);
        lnCamera.setOnClickListener(this::takePhoto);
        lnPhotoVideo.setOnClickListener(v -> {
            Intent chooser = new Intent("android.intent.action.GET_CONTENT");
            Uri uri = Uri.parse((String)Environment.getDownloadCacheDirectory().getPath());
            chooser.addCategory("android.intent.category.OPENABLE");
            chooser.setDataAndType(uri, "*/*");
            try {
                this.startActivityForResult(chooser, 100);
            }
            catch (ActivityNotFoundException ex) {
                Toast.makeText((Context)this.context, (CharSequence)"Please install app to open it.", (int)0).show();
            }
        });
        lnCancel.setOnClickListener(v -> this.finish());
        if (Conf.CHAT_DARK_MODE) {
            CardView cardOptions = (CardView)this.findViewById(R.id.cardOptions);
            cardOptions.setCardBackgroundColor(this.getResources().getColor(R.color.primaryLightColorDark));
            CardView cardCancel = (CardView)this.findViewById(R.id.cardCancel);
            cardCancel.setCardBackgroundColor(this.getResources().getColor(R.color.primaryLightColorDark));
            TextView tvPhotoVideoTitle = (TextView)this.findViewById(R.id.tvPhotoVideoTitle);
            tvPhotoVideoTitle.setTextColor(this.getResources().getColor(R.color.textColorDark));
            TextView tvCameraTitle = (TextView)this.findViewById(R.id.tvCameraTitle);
            tvCameraTitle.setTextColor(this.getResources().getColor(R.color.textColorDark));
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0 && resultCode == -1) {
            ContentResolver cr = this.getContentResolver();
            this.getContentResolver().notifyChange(this.outputFileUri, null);
            if (Build.VERSION.SDK_INT >= 24) {
                this.setPathToFile(this.getImageFilePath(this.outputFileUri), "photo");
            } else {
                this.setPathToFile(this.outputFileUri.getPath(), "photo");
            }
            this.finish();
        } else if (requestCode == 0 && resultCode == 0) {
            this.finish();
        } else if (requestCode == 100 && data != null) {
            String selectedImagePath = FilePath.getPath(this.getApplicationContext(), data.getData());
            if (selectedImagePath != null) {
                File filex = new File(selectedImagePath);
                if (filex.exists()) {
                    Log.d((String)TAG, (String)"EXISTS");
                }
                switch (selectedImagePath.substring(selectedImagePath.lastIndexOf(".") + 1).toUpperCase()) {
                    case "JPG": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "photo");
                        break;
                    }
                    case "JPEG": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "photo");
                        break;
                    }
                    case "BMP": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "photo");
                    }
                    case "TIFF": 
                    case "PNG": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "photo");
                        break;
                    }
                    case "3GP": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "video");
                        break;
                    }
                    case "MP4": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "video");
                        break;
                    }
                    case "MPEG": {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "video");
                        break;
                    }
                    default: {
                        this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "file");
                        break;
                    }
                }
            } else {
                Toast.makeText((Context)this.context, (CharSequence)this.getString(R.string.not_supported), (int)1).show();
            }
            this.finish();
        }
    }

    public void takePhoto(View view) {
        if (Build.VERSION.SDK_INT >= 24) {
            ContentValues values = new ContentValues(1);
            values.put("mime_type", "image/jpg");
            this.outputFileUri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
            Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            captureIntent.addFlags(3);
            captureIntent.putExtra("output", (Parcelable)this.outputFileUri);
            this.startActivityForResult(captureIntent, 0);
        } else {
            Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            File file = new File(Environment.getExternalStorageDirectory(), Utils.getDateName() + ".jpg");
            this.outputFileUri = Uri.fromFile((File)file);
            captureIntent.putExtra("output", (Parcelable)this.outputFileUri);
            this.startActivityForResult(captureIntent, 0);
        }
    }

    public String getImageFilePath(Uri uri) {
        String path = null;
        String image_id = null;
        Cursor cursor = this.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            image_id = cursor.getString(0);
            image_id = image_id.substring(image_id.lastIndexOf(":") + 1);
            cursor.close();
        }
        if ((cursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, "_id = ? ", new String[]{image_id}, null)) != null) {
            cursor.moveToFirst();
            path = cursor.getString(cursor.getColumnIndex("_data"));
            cursor.close();
        }
        return path;
    }

    protected void onStart() {
        super.onStart();
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)this);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean("pickFile", true);
        editor.commit();
    }

    private void setPathToFile(String abolutePath, String type) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)this);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean("pickFile", false);
        editor.putString("pathToFile", abolutePath);
        editor.putString("fileType", type);
        editor.commit();
    }
}

