/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import androidx.core.app.ActivityCompat;
import com.siggytech.utils.communication.NotificationService;
import com.siggytech.utils.communication.Utils;

public class NotificationAgent {
    public void register(Context context, int idGroup, String API_KEY, String nameClient, String iconName) {
        Intent intent = new Intent(context, NotificationService.class);
        intent.putExtra("imei", this.getIMEINumber(context));
        intent.putExtra("clientname", nameClient);
        intent.putExtra("groupid", idGroup);
        intent.putExtra("api_key", API_KEY);
        intent.putExtra("iconName", iconName);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("imei", this.getIMEINumber(context));
        editor.putString("clientname", nameClient);
        editor.putString("groupid", String.valueOf(idGroup));
        editor.putString("api_key", API_KEY);
        editor.putString("iconName", iconName);
        editor.commit();
        Utils.writeToFile(this.getIMEINumber(context).toString() + ";" + nameClient + ";" + API_KEY + ";" + String.valueOf(idGroup) + ";" + iconName, context);
        context.startService(intent);
    }

    private String getIMEINumber(Context context) {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }
}

