/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.os.StrictMode;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.siggytech.utils.communication.AESUtils;
import com.siggytech.utils.communication.ChatModel;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.CustomAdapterBubble;
import com.siggytech.utils.communication.MessageModel;
import com.siggytech.utils.communication.PaginationScrollListener;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Socket;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.WebSocketChatService;
import com.siggytech.utils.communication.async.AsyncTaskCompleteListener;
import com.siggytech.utils.communication.async.CallTask;
import com.siggytech.utils.communication.async.TaskMessage;
import com.siggytech.utils.communication.repo.DbHelper;
import com.siggytech.utils.communication.repo.MessageRaw;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;

public class ChatListView
extends RecyclerView
implements AsyncTaskCompleteListener<TaskMessage> {
    private String TAG = ChatListView.class.getSimpleName();
    List<ChatModel> lsChat = new ArrayList<ChatModel>();
    Context context;
    private String packageName;
    int resIcon;
    private Socket socket;
    private Gson gson;
    private Activity mActivity;
    private long idGroup;
    private DbHelper dbHelper;
    private String apiKey;
    private int limitCount = 10;
    private static final int PAGE_START = 0;
    private boolean isLoading = false;
    private boolean isLastPage = false;
    private int currentPage = 0;
    private long TOTAL_PAGES = 1L;

    public ChatListView(Context context, Activity activity, long idGroup, String API_KEY, String nameClient, String packageName, int resIcon) {
        super(context);
        this.context = context;
        this.mActivity = activity;
        this.packageName = packageName;
        this.resIcon = resIcon;
        this.gson = Utils.getGson();
        this.idGroup = idGroup;
        this.dbHelper = new DbHelper((Context)activity);
        this.apiKey = API_KEY;
        try {
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
            String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_CHAT_PORT_IN + "?imei=" + this.getIMEINumber() + "&groupId=" + idGroup + "&API_KEY=" + API_KEY + "&clientName=" + nameClient;
            this.socket = Socket.Builder.with(url).build().connect();
            if (!Utils.isServiceRunning(WebSocketChatService.class, context)) {
                Intent i = new Intent(context, WebSocketChatService.class);
                i.putExtra("name", nameClient);
                i.putExtra("idGroup", idGroup);
                i.putExtra("imei", this.getIMEINumber());
                i.putExtra("apiKey", API_KEY);
                context.startService(i);
            } else {
                Utils.traces("ChatListView WebSocketChatService already exists");
            }
        }
        catch (Exception ex) {
            Utils.traces("On new ChatListView : " + Utils.exceptionToString(ex));
        }
        this.addLastMessages();
        this.setAdapter();
    }

    private void addLastMessages() {
        this.getTotalPagesCount();
        this.addRawList(this.dbHelper.getMessage(this.idGroup, this.apiKey, 0, this.limitCount), false);
    }

    private void getTotalPagesCount() {
        try {
            long rowCount = this.dbHelper.getMessageCount(this.idGroup, this.apiKey);
            if (rowCount > 0L) {
                this.TOTAL_PAGES = (int)Math.ceil((double)rowCount / (double)this.limitCount);
            }
            if (this.TOTAL_PAGES == 0L) {
                ++this.TOTAL_PAGES;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAdapter() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.context);
        linearLayoutManager.setStackFromEnd(true);
        this.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.setHasFixedSize(true);
        this.setAdapter(new CustomAdapterBubble(this.lsChat, this.context, this.mActivity));
        this.addOnScrollListener(new PaginationScrollListener(linearLayoutManager){

            @Override
            protected void loadMoreItems() {
                ChatListView.this.isLoading = true;
                ChatListView.this.currentPage = ChatListView.this.currentPage + 1;
                ChatListView.this.post(() -> ChatListView.this.loadNextPage());
            }

            @Override
            public long getTotalPageCount() {
                return ChatListView.this.TOTAL_PAGES;
            }

            @Override
            public boolean isLastPage() {
                return ChatListView.this.isLastPage;
            }

            @Override
            public boolean isLoading() {
                return ChatListView.this.isLoading;
            }
        });
        Objects.requireNonNull(this.getLayoutManager()).scrollToPosition(Objects.requireNonNull(this.getAdapter()).getItemCount() - 1);
    }

    private void notifyItemInserted() {
        Objects.requireNonNull(this.getAdapter()).notifyItemInserted(this.lsChat.size() - 1);
        Objects.requireNonNull(this.getLayoutManager()).scrollToPosition(this.getAdapter().getItemCount() - 1);
    }

    private String getIMEINumber() {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)this.context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }

    public void addNotification(String title, String text, String packageName, Class<?> launchClass, int resIcon, String notificationMessage) {
        PackageManager pmg = this.context.getPackageManager();
        String name = "";
        Intent LaunchIntent = null;
        try {
            if (pmg != null) {
                ApplicationInfo app = this.context.getPackageManager().getApplicationInfo(packageName, 0);
                name = (String)pmg.getApplicationLabel(app);
                LaunchIntent = new Intent(this.context, launchClass);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && mNotificationManager.getNotificationChannel(Conf.FOREGROUND_CHANNEL_ID) == null) {
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(Conf.FOREGROUND_CHANNEL_ID, (CharSequence)name, importance);
            channel.enableVibration(false);
            mNotificationManager.createNotificationChannel(channel);
        }
        Intent intent = LaunchIntent;
        intent.putExtra("notificationMessage", notificationMessage);
        intent.addFlags(0x34000000);
        PendingIntent pIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x40000000);
        NotificationCompat.Builder notificationBuilder = Build.VERSION.SDK_INT >= 26 ? new NotificationCompat.Builder(this.context, Conf.FOREGROUND_CHANNEL_ID) : new NotificationCompat.Builder(this.context);
        Uri uri = RingtoneManager.getDefaultUri((int)2);
        notificationBuilder.setContentTitle((CharSequence)title).setContentText((CharSequence)text).setCategory("msg").setContentIntent(pIntent).setSound(uri).setSmallIcon(resIcon).setAutoCancel(true);
        if (Build.VERSION.SDK_INT >= 21) {
            notificationBuilder.setVisibility(1);
        }
        Notification notification = notificationBuilder.build();
        notification.flags |= 0x10;
        mNotificationManager.notify(Conf.NOTIFICATION_ID_FOREGROUND_SERVICE, notification);
        PowerManager pm = (PowerManager)this.context.getSystemService("power");
        boolean isScreenOn = pm.isScreenOn();
        if (!isScreenOn) {
            PowerManager.WakeLock wl = pm.newWakeLock(805306394, this.TAG);
            wl.acquire(10000L);
            PowerManager.WakeLock wl_cpu = pm.newWakeLock(1, "MyCpuLock");
            wl_cpu.acquire(10000L);
        }
    }

    private boolean appInForeground(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List runningAppProcesses = activityManager.getRunningAppProcesses();
        if (runningAppProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcess : runningAppProcesses) {
            if (!runningAppProcess.processName.equals(context.getPackageName()) || runningAppProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public void sendMessage(String from, String encryptedData, String dateTime, String type, long idGroup) {
        try {
            this.socket.sendOnOpen(type, "{\n    \"from\": \"" + from + "\",\n    \"text\": \"" + encryptedData + "\", \n    \"dateTime\": \"" + dateTime + "\", \n    \"idGroup\": \"" + idGroup + "\" \n}");
            MessageRaw messageRaw = new MessageRaw();
            messageRaw.setUserKey(this.apiKey);
            messageRaw.setIdGroup(String.valueOf(idGroup));
            messageRaw.setFrom(from);
            messageRaw.setMessage(encryptedData);
            messageRaw.setDate(dateTime);
            messageRaw.setMine(1);
            long id2 = this.dbHelper.insertMessage(messageRaw);
            Log.e((String)"KUSSES", (String)("INSERT: " + id2 + "; ID GROUP:" + idGroup));
            MessageModel model = (MessageModel)this.gson.fromJson(AESUtils.decText(encryptedData), MessageModel.class);
            this.lsChat.add(new ChatModel(1L, model, Conf.LOCAL_USER, dateTime, true));
            this.notifyItemInserted();
        }
        catch (Exception e) {
            Utils.traces("ChatListView sendMessage : " + Utils.exceptionToString(e));
        }
    }

    public void callToBase64(MessageModel messageModel) {
        try {
            new CallTask(this.context, this).execute(new Object[]{messageModel});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onTaskCompleted(TaskMessage result) {
        try {
            if (result != null && result.getMessageModel() != null) {
                this.sendMessage(result.getMessageModel().getFrom(), AESUtils.encText(this.gson.toJson((Object)result.getMessageModel())), result.getMessageModel().getDate(), result.getMessageModel().getType(), this.idGroup);
            }
        }
        catch (Exception e) {
            Utils.traces("ChatListView onTaskCompleted : " + Utils.exceptionToString(e));
        }
    }

    public void onMessageReceiver(String text) {
        try {
            Utils.traces("1.- ChatListView onMessageReceiver");
            JSONObject jObject = new JSONObject(text);
            String idGroupFrom = new JSONObject(jObject.getString("data")).getString("idGroupFrom");
            String from = new JSONObject(jObject.getString("data")).getString("from");
            String messageText1 = new JSONObject(jObject.getString("data")).getString("text");
            String dateTime = Utils.getStringDate();
            MessageModel model = null;
            if (!this.appInForeground(this.context)) {
                model = (MessageModel)this.gson.fromJson(AESUtils.decText(messageText1), MessageModel.class);
                String messageText = this.context.getString(R.string.new_message);
                if ("Message".equals(model.getType())) {
                    messageText = model.getMessage();
                }
                this.addNotification(from, messageText, this.packageName, this.mActivity.getClass(), this.resIcon, text);
            }
            Utils.traces("1.- ChatListView onMessageReceiver idGroup: " + this.idGroup + "; al que llega: " + idGroupFrom);
            if (this.idGroup == Long.parseLong(idGroupFrom)) {
                if (model == null) {
                    model = (MessageModel)this.gson.fromJson(AESUtils.decText(messageText1), MessageModel.class);
                }
                Utils.traces("1.- ChatListView onMessageReceiver entro a agregar al chat");
                this.lsChat.add(new ChatModel(1L, model, from, dateTime, false));
                this.notifyItemInserted();
            }
        }
        catch (Exception ex) {
            Utils.traces("ChatListView onMessageReceiver : " + Utils.exceptionToString(ex));
        }
    }

    public void onDestroy() {
        try {
            if (this.dbHelper != null) {
                this.dbHelper.close();
            }
        }
        catch (Exception e) {
            Utils.traces("onDestroy ChatListView ex: " + (e != null ? e.getMessage() : null));
        }
    }

    public void setGroupView(long idGroup, int limit) {
        this.limitCount = limit;
        this.getTotalPagesCount();
        if (this.idGroup != idGroup) {
            this.idGroup = idGroup;
            this.addRawList(this.dbHelper.getMessage(idGroup, this.apiKey, 0, limit), true);
        }
    }

    private void addRawList(List<MessageRaw> list, boolean notify) {
        try {
            this.lsChat.clear();
            for (MessageRaw raw2 : list) {
                this.lsChat.add(new ChatModel(1L, (MessageModel)this.gson.fromJson(AESUtils.decText(raw2.getMessage()), MessageModel.class), raw2.getFrom(), raw2.getDate(), raw2.getMine() != 0));
            }
            if (notify) {
                this.setAdapter(new CustomAdapterBubble(this.lsChat, this.context, this.mActivity));
                Objects.requireNonNull(this.getLayoutManager()).scrollToPosition(Objects.requireNonNull(this.getAdapter()).getItemCount() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadNextPage() {
        Log.d((String)this.TAG, (String)("loadNextPage: " + this.currentPage + "; TOTAL_PAGES: " + this.TOTAL_PAGES));
        List<MessageRaw> list = this.dbHelper.getMessage(this.idGroup, this.apiKey, this.lsChat.size() - 1, this.limitCount);
        Collections.reverse(list);
        ((CustomAdapterBubble)Objects.requireNonNull(this.getAdapter())).removeLoadingHeader();
        this.isLoading = false;
        try {
            for (MessageRaw raw2 : list) {
                ((CustomAdapterBubble)Objects.requireNonNull(this.getAdapter())).add(new ChatModel(1L, (MessageModel)this.gson.fromJson(AESUtils.decText(raw2.getMessage()), MessageModel.class), raw2.getFrom(), raw2.getDate(), raw2.getMine() != 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((long)this.currentPage != this.TOTAL_PAGES) {
            ((CustomAdapterBubble)Objects.requireNonNull(this.getAdapter())).addLoadingHeader();
        } else {
            this.isLastPage = true;
        }
    }

    public void deleteHistory() {
        this.dbHelper.deleteHistory();
    }
}

