/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication.async;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import com.siggytech.utils.communication.MessageModel;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.async.AsyncTaskCompleteListener;
import com.siggytech.utils.communication.async.TaskMessage;

public class CallTask
extends AsyncTask<Object, Void, TaskMessage> {
    private static final String TAG = CallTask.class.getSimpleName();
    private Context context;
    private AsyncTaskCompleteListener<TaskMessage> listener;
    private ProgressDialog progressDialog;

    public CallTask(Context context, AsyncTaskCompleteListener<TaskMessage> listener) {
        this.context = context;
        this.listener = listener;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.progressDialog = new ProgressDialog(this.context);
        this.progressDialog.setMessage((CharSequence)"Wait...");
        this.progressDialog.setCanceledOnTouchOutside(false);
        this.progressDialog.show();
    }

    protected TaskMessage doInBackground(Object ... objects) {
        TaskMessage message = new TaskMessage();
        try {
            MessageModel messageModel = (MessageModel)objects[0];
            messageModel.setMessage(Utils.FileToBase64(messageModel.getFile()));
            message.setMessage("OK");
            message.setMessageModel(messageModel);
            return message;
        }
        catch (Exception e) {
            message.setError(true);
            message.setMessage("Error: " + e.getMessage());
            message.setException(e);
            return message;
        }
    }

    protected void onPostExecute(TaskMessage message) {
        super.onPostExecute((Object)message);
        message.getMessageModel().setFile(null);
        this.listener.onTaskCompleted(message);
        this.progressDialog.dismiss();
    }
}

