/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import com.google.gson.Gson;
import com.siggytech.utils.communication.AESUtils;
import com.siggytech.utils.communication.ChatListView;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.MessageModel;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.UtilActivity;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.audio.AudioRecorder;
import java.io.File;

public class ChatControl
extends RelativeLayout {
    private static final String TAG = ChatControl.class.getSimpleName();
    public static final int MESSAGE_READ = 1;
    public static final int MESSAGE_WRITE = 2;
    public static final int SELECT_FILE = 100;
    private ListView mConversationView;
    private EditText mOutEditText;
    private EditText mServerAddress;
    private LinearLayout mSendButton;
    private LinearLayout mAddFile;
    private LinearLayout mAudio;
    private TextView mAudioText;
    private AudioRecorder ar;
    private boolean isPickingFile = false;
    Handler timerHandler = new Handler();
    private String filePath;
    public String imei;
    public String name;
    public String api_key;
    public String userName;
    public int idGroup;
    private final Context context;
    private ChatListView chatListView;
    private String packageName;
    private int resIcon;
    private Activity mActivity;
    private Gson gson;
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            block11: {
                if (ChatControl.this.isPickingFile) {
                    SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)ChatControl.this.context);
                    boolean pickFile = settings.getBoolean("pickFile", true);
                    boolean deleteFile = true;
                    if (!pickFile) {
                        try {
                            String fileType = settings.getString("fileType", "photo");
                            String pathToFile = settings.getString("pathToFile", "");
                            File file = new File(pathToFile);
                            if (!file.exists()) {
                                file = new File(Utils.getRealPathFromURI(ChatControl.this.context, Uri.parse((String)pathToFile)));
                            }
                            if (file.exists()) {
                                boolean deleted;
                                MessageModel messageModel = new MessageModel();
                                if ("photo".equals(fileType)) {
                                    messageModel.setMessage(Utils.FileToBase64(Utils.CompressImage(pathToFile)));
                                }
                                messageModel.setType(fileType);
                                messageModel.setFrom(ChatControl.this.userName);
                                messageModel.setDate(Utils.GetStringDate());
                                if ("video".equals(fileType)) {
                                    deleteFile = false;
                                    messageModel.setFile(file);
                                    ChatControl.this.chatListView.callToBase64(messageModel);
                                } else {
                                    ChatControl.this.chatListView.sendMessage(ChatControl.this.userName, AESUtils.encText(ChatControl.this.gson.toJson((Object)messageModel)), Utils.GetStringDate(), fileType);
                                }
                                ChatControl.this.isPickingFile = false;
                                if (deleteFile && pathToFile.contains("SIGGI") && !(deleted = ChatControl.this.deleteFile(file))) {
                                    Log.d((String)TAG, (String)"CAN'T DELETE FILE!");
                                }
                                break block11;
                            }
                            ChatControl.this.isPickingFile = false;
                            Toast.makeText((Context)ChatControl.this.context, (CharSequence)("CAN'T FIND FILE: " + pathToFile), (int)1).show();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        ChatControl.this.timerHandler.postDelayed(ChatControl.this.timerRunnable, 1000L);
                    }
                }
            }
        }
    };
    private long startHTime = 0L;
    private Handler customHandler = new Handler();
    long timeInMilliseconds = 0L;
    long timeSwapBuff = 0L;
    long updatedTime = 0L;
    private Runnable updateTimerThread = new Runnable(){

        @Override
        public void run() {
            ChatControl.this.timeInMilliseconds = SystemClock.uptimeMillis() - ChatControl.this.startHTime;
            ChatControl.this.updatedTime = ChatControl.this.timeSwapBuff + ChatControl.this.timeInMilliseconds;
            int secs = (int)(ChatControl.this.updatedTime / 1000L);
            int mins = secs / 60;
            secs %= 60;
            ChatControl.this.ar.setDuration((int)(ChatControl.this.updatedTime / 1000L));
            if (ChatControl.this.mAudioText != null) {
                ChatControl.this.mAudioText.setText((CharSequence)String.format("%02d:%02d", mins, secs));
            }
            ChatControl.this.customHandler.postDelayed((Runnable)this, 0L);
        }
    };

    public ChatControl(Context context, int idGroup, String API_KEY, String nameClient, String userName, String packageName, int resIcon, Activity activity) {
        super(context);
        this.context = context;
        this.idGroup = idGroup;
        this.api_key = API_KEY;
        this.name = nameClient;
        this.imei = this.getIMEINumber();
        this.userName = userName;
        this.packageName = packageName;
        this.resIcon = resIcon;
        this.mActivity = activity;
        this.gson = new Gson();
        this.initLayout(context);
    }

    private String getIMEINumber() {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)this.context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void initLayout(Context context) {
        int idContent = Utils.GenerateViewId();
        ViewGroup.LayoutParams root_LayoutParams = new ViewGroup.LayoutParams(-2, -2);
        root_LayoutParams.width = -1;
        root_LayoutParams.height = -1;
        this.setLayoutParams(root_LayoutParams);
        RelativeLayout rl = new RelativeLayout(context);
        this.chatListView = new ChatListView(context, this.mActivity, this.idGroup, this.api_key, this.name, this.packageName, this.resIcon);
        this.chatListView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        RelativeLayout.LayoutParams abc_LayoutParams = new RelativeLayout.LayoutParams(-1, -1);
        abc_LayoutParams.width = -1;
        abc_LayoutParams.height = -1;
        abc_LayoutParams.addRule(11, -1);
        abc_LayoutParams.addRule(2, idContent);
        rl.addView((View)this.chatListView);
        this.addView((View)rl);
        rl.setLayoutParams((ViewGroup.LayoutParams)abc_LayoutParams);
        rl.setId(Utils.GenerateViewId());
        this.mOutEditText = new EditText(context);
        this.mOutEditText.setId(Utils.GenerateViewId());
        this.mOutEditText.setMaxLines(5);
        this.mOutEditText.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -2));
        this.mOutEditText.setBackgroundResource(R.drawable.gradientbg);
        this.mSendButton = new LinearLayout(context);
        this.mSendButton.setId(Utils.GenerateViewId());
        this.mSendButton.setGravity(17);
        this.mSendButton.setPadding(10, 10, 10, 15);
        if (!Conf.CHAT_BASIC) {
            this.mSendButton.setVisibility(8);
        }
        ImageView iv = new ImageView(context);
        iv.setImageDrawable(this.getResources().getDrawable(R.drawable.ic_send_24dp));
        iv.setColorFilter(Conf.CHAT_COLOR_COMPONENTS);
        this.mSendButton.addView((View)iv);
        this.mAudio = new LinearLayout(context);
        this.mAudio.setPadding(10, 10, 10, 15);
        this.mAudio.setId(Utils.GenerateViewId());
        this.mAudio.setGravity(17);
        ImageView ivMic = new ImageView(context);
        ivMic.setImageDrawable(this.getResources().getDrawable(R.drawable.ic_mic_none_24dp));
        ivMic.setColorFilter(Conf.CHAT_COLOR_COMPONENTS);
        this.mAudio.addView((View)ivMic);
        this.mAudioText = new TextView(context);
        this.mAudioText.setText((CharSequence)"00:00");
        this.mAudioText.setTextColor(this.getResources().getColor(R.color.bt_dark_gray));
        this.mAudioText.setTextSize(2, 17.0f);
        this.mAudioText.setPadding(20, 0, 0, 0);
        this.mAudioText.setVisibility(8);
        this.mAddFile = new LinearLayout(context);
        this.mAddFile.setPadding(20, 10, 10, 15);
        this.mAddFile.setId(Utils.GenerateViewId());
        this.mAddFile.setGravity(17);
        ImageView ivAdd = new ImageView(context);
        ivAdd.setImageDrawable(this.getResources().getDrawable(R.drawable.ic_add_24dp));
        ivAdd.setColorFilter(Conf.CHAT_COLOR_COMPONENTS);
        this.mAddFile.addView((View)ivAdd);
        ImageView ivMic2 = new ImageView(context);
        ivMic2.setImageDrawable(this.getResources().getDrawable(R.drawable.ic_mic_none_gray_24dp));
        ivMic2.setVisibility(8);
        this.mAddFile.addView((View)ivMic2);
        RelativeLayout.LayoutParams mContentParams = new RelativeLayout.LayoutParams(-1, -2);
        mContentParams.addRule(12, -1);
        LinearLayout lnContent = new LinearLayout(context);
        lnContent.setId(idContent);
        lnContent.setLayoutParams((ViewGroup.LayoutParams)mContentParams);
        lnContent.setBackgroundColor(this.getResources().getColor(R.color.light_grey));
        lnContent.setPadding(10, 10, 10, 20);
        LinearLayout lnSend = this.getLnContentSum(6.0f);
        lnSend.setGravity(1);
        LinearLayout lnH0 = this.getLnWeight(1.0f);
        lnH0.setVerticalGravity(81);
        LinearLayout lnH1 = this.getLnWeight(Conf.CHAT_BASIC ? 5.0f : 4.0f);
        lnH1.setVerticalGravity(17);
        LinearLayout lnH2 = this.getLnWeight(1.0f);
        lnH2.setGravity(81);
        lnH0.addView((View)this.mAddFile);
        if (!Conf.SEND_FILES) {
            lnH0.setVisibility(8);
        }
        lnH1.addView((View)this.mOutEditText);
        lnH1.addView((View)this.mAudioText);
        lnH2.addView((View)this.mSendButton);
        if (!Conf.CHAT_BASIC) {
            lnH2.addView((View)this.mAudio);
            lnSend.addView((View)lnH0);
        }
        lnSend.addView((View)lnH1);
        lnSend.addView((View)lnH2);
        lnContent.addView((View)lnSend);
        this.addView((View)lnContent);
        if (!Conf.CHAT_BASIC) {
            TextWatcher excludeTW = new TextWatcher(){

                public void afterTextChanged(Editable s) {
                }

                public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    if (count > 0) {
                        ChatControl.this.mAudio.setVisibility(8);
                        ChatControl.this.mSendButton.setVisibility(0);
                    } else {
                        ChatControl.this.mAudio.setVisibility(0);
                        ChatControl.this.mSendButton.setVisibility(8);
                    }
                }
            };
            this.mOutEditText.addTextChangedListener(excludeTW);
            this.mAudio.setOnTouchListener((v, event) -> {
                switch (event.getAction()) {
                    case 0: {
                        this.setFocusable(true);
                        this.requestFocus();
                        ivAdd.setVisibility(8);
                        ivMic2.setVisibility(0);
                        this.mOutEditText.setVisibility(8);
                        this.mAudioText.setVisibility(0);
                        this.filePath = Conf.ROOT_PATH + Utils.GetDateName() + ".3gp";
                        this.ar = new AudioRecorder(this.filePath);
                        this.audioRecording(true);
                        return true;
                    }
                    case 1: {
                        try {
                            this.audioRecording(false);
                            this.mAudioText.setText((CharSequence)"00:00");
                            File audioFile = new File(this.filePath);
                            if (this.ar.getDuration() > 1) {
                                MessageModel messageModel = new MessageModel();
                                messageModel.setType("audio");
                                messageModel.setMessage(Utils.FileToBase64(audioFile));
                                messageModel.setDuration(this.ar.getDuration());
                                if (audioFile != null && audioFile.length() > 0L) {
                                    this.chatListView.sendMessage(this.userName, AESUtils.encText(this.gson.toJson((Object)messageModel)), Utils.GetStringDate(), "audio");
                                }
                            }
                            this.ar.setDuration(0);
                            this.timeSwapBuff = 0L;
                            boolean deleted = this.deleteFile(audioFile);
                            if (!deleted) {
                                Log.d((String)TAG, (String)"CAN'T DELETE FILE!!!");
                            }
                            ivAdd.setVisibility(0);
                            ivMic2.setVisibility(8);
                            this.mOutEditText.setVisibility(0);
                            this.mAudioText.setVisibility(8);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                }
                return false;
            });
        }
        this.mSendButton.setOnClickListener(view -> {
            try {
                if (!"".equals(this.mOutEditText.getText().toString().trim())) {
                    MessageModel messageModel = new MessageModel();
                    messageModel.setType("Message");
                    messageModel.setMessage(this.mOutEditText.getText().toString());
                    this.chatListView.sendMessage(this.userName, AESUtils.encText(this.gson.toJson((Object)messageModel)), Utils.GetStringDate(), "Message");
                    this.mOutEditText.setText((CharSequence)"");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.mAddFile.setOnClickListener(view -> {
            try {
                this.mActivity.startActivity(new Intent(context, UtilActivity.class));
                this.clearPersistentVariables();
                this.timerHandler.postDelayed(this.timerRunnable, 0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void clearPersistentVariables() {
        this.isPickingFile = true;
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        SharedPreferences.Editor editor = settings.edit();
        settings.edit().remove("pickFile").commit();
        settings.edit().remove("pathToFile").commit();
        settings.edit().remove("fileType").commit();
        editor.commit();
    }

    private LinearLayout getLnContentSum(float weight) {
        LinearLayout lnContent2 = new LinearLayout(this.context);
        lnContent2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        lnContent2.setOrientation(0);
        lnContent2.setWeightSum(weight);
        return lnContent2;
    }

    private LinearLayout getLnWeight(float weight) {
        LinearLayout ln = new LinearLayout(this.context);
        ln.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, weight));
        return ln;
    }

    public EditText getmOutEditText() {
        return this.mOutEditText;
    }

    public LinearLayout getmSendButton() {
        return this.mSendButton;
    }

    private void audioRecording(boolean start) {
        if (start) {
            try {
                this.ar.start();
                this.startHTime = SystemClock.uptimeMillis();
                this.customHandler.postDelayed(this.updateTimerThread, 0L);
            }
            catch (Exception e) {
                Log.e((String)"Exception in start", (String)("" + e));
            }
        } else {
            try {
                this.ar.stop();
                this.timeSwapBuff += this.timeInMilliseconds;
                this.customHandler.removeCallbacks(this.updateTimerThread);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean deleteFile(File file) {
        boolean deleted = false;
        try {
            if (file != null) {
                deleted = file.delete();
            }
        }
        catch (Exception e) {
            deleted = false;
            e.printStackTrace();
        }
        return deleted;
    }
}

