/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.util.Base64;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static final int pswdIterations = 10;
    private static final int keySize = 128;
    private static final String cypherInstance = "AES/CBC/PKCS5Padding";
    private static final String secretKeyInstance = "PBKDF2WithHmacSHA1";
    private static final String plainText = "lsjgirnKVRKP867";
    private static final String AESSalt = "9gje84hc9FKEef8";
    private static final String initializationVector = "3197418115125014";
    private static final byte[] key = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 1, 2, 3, 4, 5, 6};
    private static final byte[] ivk = new byte[]{6, 9, 6, 9, 4, 4, 7, 0, 7, 1, 1, 0, 2, 3, 3, 4};

    public static String encrypt(String textToEncrypt) throws Exception {
        SecretKeySpec skeySpec = new SecretKeySpec(AESUtils.getRaw(plainText, AESSalt), "AES");
        Cipher cipher = Cipher.getInstance(cypherInstance);
        cipher.init(1, (Key)skeySpec, new IvParameterSpec(initializationVector.getBytes()));
        byte[] encrypted = cipher.doFinal(textToEncrypt.getBytes());
        return Base64.encodeToString((byte[])encrypted, (int)0);
    }

    public static String decrypt(String textToDecrypt) throws Exception {
        byte[] encryted_bytes = Base64.decode((String)textToDecrypt, (int)0);
        SecretKeySpec skeySpec = new SecretKeySpec(AESUtils.getRaw(plainText, AESSalt), "AES");
        Cipher cipher = Cipher.getInstance(cypherInstance);
        cipher.init(2, (Key)skeySpec, new IvParameterSpec(initializationVector.getBytes()));
        byte[] decrypted = cipher.doFinal(encryted_bytes);
        return new String(decrypted, "UTF-8");
    }

    private static byte[] getRaw(String plainText, String salt) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(secretKeyInstance);
            PBEKeySpec spec = new PBEKeySpec(plainText.toCharArray(), salt.getBytes(), 10, 128);
            return factory.generateSecret(spec).getEncoded();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    public static final byte[] encBytes(byte[] srcBytes) throws Exception {
        Cipher cipher = Cipher.getInstance(cypherInstance);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec iv = new IvParameterSpec(ivk);
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(srcBytes);
        return encrypted;
    }

    public static final String encText(String sSrc) throws Exception {
        byte[] srcBytes = sSrc.getBytes("utf-8");
        byte[] encrypted = AESUtils.encBytes(srcBytes);
        return Base64.encodeToString((byte[])encrypted, (int)0);
    }

    public static final byte[] decBytes(byte[] srcBytes) throws Exception {
        Cipher cipher = Cipher.getInstance(cypherInstance);
        SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec iv = new IvParameterSpec(ivk);
        cipher.init(2, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(srcBytes);
        return encrypted;
    }

    public static final String decText(String sSrc) throws Exception {
        byte[] srcBytes = Base64.decode((String)sSrc, (int)0);
        byte[] decrypted = AESUtils.decBytes(srcBytes);
        return new String(decrypted, "utf-8");
    }
}

