/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.core.widget.ContentLoadingProgressBar;
import com.siggytech.utils.communication.R;

public class MyImage
extends RelativeLayout {
    private ContentLoadingProgressBar progressBar;
    private ImageView imageView;

    public MyImage(Context context) {
        super(context);
        this.init();
    }

    public MyImage(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MyImage(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        MyImage.inflate((Context)this.getContext(), (int)R.layout.my_image, (ViewGroup)this);
        this.progressBar = (ContentLoadingProgressBar)this.findViewById(R.id.pbProgress);
        this.imageView = (ImageView)this.findViewById(R.id.ivImage);
    }

    public ContentLoadingProgressBar getProgressBar() {
        return this.progressBar;
    }

    public ImageView getImageView() {
        return this.imageView;
    }

    public void setRoundImage(Bitmap mbitmap) {
        try {
            Bitmap imageRounded = Bitmap.createBitmap((int)mbitmap.getWidth(), (int)mbitmap.getHeight(), (Bitmap.Config)mbitmap.getConfig());
            Canvas canvas = new Canvas(imageRounded);
            Paint mpaint = new Paint();
            mpaint.setAntiAlias(true);
            mpaint.setShader((Shader)new BitmapShader(mbitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)mbitmap.getWidth(), (float)mbitmap.getHeight()), 100.0f, 100.0f, mpaint);
            this.imageView.setImageBitmap(imageRounded);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

