/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.siggytech.utils.communication.Conf;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class Utils {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    @SuppressLint(value={"NewApi"})
    public static int GenerateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int newValue;
            int result;
            do {
                if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!sNextGeneratedId.compareAndSet(result, newValue));
            return result;
        }
        return View.generateViewId();
    }

    public static String GetDateName() {
        Calendar calendar = Calendar.getInstance();
        return String.valueOf(calendar.getTimeInMillis());
    }

    public static String GetStringDate() {
        String strDate = "";
        try {
            SimpleDateFormat sdf;
            switch (Conf.DATE_FORMAT) {
                case 0: {
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
                    break;
                }
                case 1: {
                    sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", Locale.US);
                    break;
                }
                default: {
                    sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm", Locale.US);
                }
            }
            Calendar cal = Calendar.getInstance();
            strDate = sdf.format(cal.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String FileToBase64(File file) {
        String base64 = "";
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        try {
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
            buf.read(bytes, 0, bytes.length);
            buf.close();
            base64 = Utils.ToBase64(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return base64;
    }

    public static String ToBase64(byte[] byteArray) {
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static Uri Base64ToUrl(String encoded, String fileName) throws Exception {
        byte[] decoded = Base64.decode((String)encoded, (int)0);
        String path = Conf.ROOT_PATH + fileName;
        try {
            File file2 = new File(path);
            FileOutputStream os = new FileOutputStream(file2, true);
            os.write(decoded);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return Uri.parse((String)path);
    }

    public static String getFileExt(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
    }

    public static Bitmap rotateImage(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static File CompressImage(Context context, Uri uri) {
        return Utils.CompressImage(Utils.getRealPathFromURI(context, uri));
    }

    public static File CompressImage(String filePath) {
        Bitmap scaledBitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float maxHeight = 816.0f;
        float maxWidth = 612.0f;
        float imgRatio = actualWidth / actualHeight;
        float maxRatio = maxWidth / maxHeight;
        if ((float)actualHeight > maxHeight || (float)actualWidth > maxWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = maxHeight / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = (int)maxHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = maxWidth / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = (int)maxWidth;
            } else {
                actualHeight = (int)maxHeight;
                actualWidth = (int)maxWidth;
            }
        }
        options.inSampleSize = Utils.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        try {
            bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        try {
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
        try {
            ExifInterface exif = new ExifInterface(filePath);
            int orientation = exif.getAttributeInt("Orientation", 0);
            Matrix matrix = new Matrix();
            if (orientation == 6) {
                matrix.postRotate(90.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            } else if (orientation == 3) {
                matrix.postRotate(180.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            } else if (orientation == 8) {
                matrix.postRotate(270.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            }
            scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream out = null;
        String filename = Utils.getFilename();
        try {
            out = new FileOutputStream(filename);
            scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return new File(filename);
    }

    public static String getRealPathFromURI(Context context, Uri uri) {
        Uri queryUri = MediaStore.Files.getContentUri((String)"external");
        if (uri.toString().contains("/storage/emulated/0") || uri.toString().contains("/storage/sdcard0")) {
            queryUri = MediaStore.Files.getContentUri((String)"internal");
        }
        String columnData = "_data";
        String columnSize = "_size";
        String[] projectionData = new String[]{"_data"};
        String name = null;
        String size = null;
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            int nameIndex = cursor.getColumnIndex("_display_name");
            int sizeIndex = cursor.getColumnIndex("_size");
            cursor.moveToFirst();
            name = cursor.getString(nameIndex);
            size = cursor.getString(sizeIndex);
            cursor.close();
        }
        String imagePath = "";
        if (name != null && size != null) {
            String selectionNS = columnData + " LIKE '%" + name + "' AND " + columnSize + "='" + size + "'";
            Cursor cursorLike = context.getContentResolver().query(queryUri, projectionData, selectionNS, null, null);
            if (cursorLike != null && cursorLike.getCount() > 0) {
                cursorLike.moveToFirst();
                int indexData = cursorLike.getColumnIndex(columnData);
                if (cursorLike.getString(indexData) != null) {
                    imagePath = cursorLike.getString(indexData);
                }
                cursorLike.close();
            }
        }
        return imagePath;
    }

    public static String getFilename() {
        File file = new File(Environment.getExternalStorageDirectory().getPath(), "SIGGI/");
        if (!file.exists()) {
            file.mkdirs();
        }
        String uriString = file.getAbsolutePath() + "/" + System.currentTimeMillis() + ".jpg";
        return uriString;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    public static Gson GetGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getAnnotation(Expose.class) != null;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }});
        gsonBuilder.disableHtmlEscaping();
        return gsonBuilder.serializeNulls().create();
    }

    public class MESSAGE_TYPE {
        public static final String MESSAGE = "Message";
        public static final String AUDIO = "audio";
        public static final String PHOTO = "photo";
        public static final String VIDEO = "video";
        public static final String FILE = "file";
    }
}

