/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.appcompat.app.AppCompatActivity;
import com.siggytech.utils.communication.MessengerService;
import com.siggytech.utils.communication.MyScheduleReceiver;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class NotificatorSocket
extends AppCompatActivity {
    public static final String BROADCAST = "com.siggy.notificator.MessengerBroadcastReceiver";
    private UDPThread SocketRecv;
    private MessengerService messengerService;
    Intent mServiceIntent;
    Context context;
    public String packageName;
    private int localport = 1984;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    private void register() {
        this.messengerService = new MessengerService(this.context);
        this.mServiceIntent = new Intent(this.context, ((Object)((Object)this.messengerService)).getClass());
        if (!this.isMyServiceRunning(((Object)((Object)this.messengerService)).getClass())) {
            this.mServiceIntent.putExtra("packageName", this.packageName);
            this.context.startService(this.mServiceIntent);
        }
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            Log.i((String)"isMyServiceRunning?", (String)"true");
            return true;
        }
        Log.i((String)"isMyServiceRunning?", (String)"false");
        return false;
    }

    public void onStop() {
        super.onStop();
        this.stopService(new Intent((Context)this, MessengerService.class));
    }

    public NotificatorSocket(Context context, String packageName, String messageTittle, String messageText) {
        this.packageName = packageName;
        this.context = context;
        Intent broadcastedIntent = new Intent(context, MyScheduleReceiver.class);
        broadcastedIntent.putExtra("FREC", 10);
        broadcastedIntent.putExtra("packageName", packageName);
        broadcastedIntent.putExtra("messageTittle", messageTittle);
        broadcastedIntent.putExtra("messageText", messageText);
        context.sendBroadcast(broadcastedIntent);
        if (this.localport <= 1024) {
            Log.e((String)"UDP", (String)"UDPSocket:1024 ");
        }
    }

    private class UDPThread
    extends Thread {
        private DatagramSocket mm_socket;
        private byte[] mm_data;
        private boolean Send_Flag = false;
        private boolean Recv_Flag = false;
        private String des_Address;
        private int desPort;

        UDPThread() {
            if (this.mm_socket == null) {
                try {
                    this.mm_socket = new DatagramSocket(null);
                    this.mm_socket.setReuseAddress(true);
                    this.mm_socket.bind(new InetSocketAddress(NotificatorSocket.this.localport));
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

