/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import androidx.core.app.ActivityCompat;
import com.siggytech.utils.communication.MessengerService;

public class NotificationAgent {
    public void register(Context context, int idGroup, String API_KEY, String nameClient) {
        Intent intent = new Intent(context, MessengerService.class);
        intent.putExtra("imei", this.getIMEINumber(context).toString());
        intent.putExtra("clientname", nameClient);
        intent.putExtra("groupid", idGroup);
        intent.putExtra("api_key", API_KEY);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("imei", this.getIMEINumber(context).toString());
        editor.putString("clientname", nameClient);
        editor.putString("groupid", String.valueOf(idGroup));
        editor.putString("api_key", API_KEY);
        editor.commit();
        context.startService(intent);
    }

    private String getIMEINumber(Context context) {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }
}

