/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.os.StrictMode;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.siggytech.utils.communication.AESUtils;
import com.siggytech.utils.communication.ChatModel;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.CustomAdapterBubble;
import com.siggytech.utils.communication.MessageModel;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Socket;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.async.AsyncTaskCompleteListener;
import com.siggytech.utils.communication.async.CallTask;
import com.siggytech.utils.communication.async.TaskMessage;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONObject;

public class ChatListView
extends RecyclerView
implements AsyncTaskCompleteListener<TaskMessage> {
    private String TAG = ChatListView.class.getSimpleName();
    List<ChatModel> lsChat = new ArrayList<ChatModel>();
    Handler timerHandler = new Handler();
    Context context;
    private int idGroup;
    private String API_KEY;
    private String imei;
    private String name;
    private boolean newMessage = false;
    private String messageText;
    private String from;
    private String dateTime;
    private String packageName;
    private String notificationMessage;
    int resIcon;
    private Socket socket;
    private Gson gson;
    private Activity mActivity;
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            if (ChatListView.this.newMessage) {
                try {
                    MessageModel model = (MessageModel)ChatListView.this.gson.fromJson(AESUtils.decText(ChatListView.this.messageText), MessageModel.class);
                    if (!ChatListView.this.appInForeground(ChatListView.this.context)) {
                        String messageText = ChatListView.this.context.getString(R.string.new_message);
                        if ("Message".equals(model.getType())) {
                            messageText = model.getMessage();
                        }
                        ChatListView.this.addNotification(ChatListView.this.from, messageText, ChatListView.this.packageName, ChatListView.this.resIcon, ChatListView.this.notificationMessage);
                    }
                    ChatListView.this.newMessage = false;
                    ChatListView.this.lsChat.add(new ChatModel(1L, model, ChatListView.this.from, ChatListView.this.dateTime, false));
                    ChatListView.this.notifyItemInserted();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ChatListView.this.timerHandler.postDelayed(ChatListView.this.timerRunnable, 100L);
        }
    };

    public ChatListView(Context context, Activity activity, int idGroup, String API_KEY, String nameClient, String packageName, int resIcon) {
        super(context);
        this.context = context;
        this.mActivity = activity;
        this.idGroup = idGroup;
        this.API_KEY = API_KEY;
        this.name = nameClient;
        this.imei = this.getIMEINumber();
        this.packageName = packageName;
        this.resIcon = resIcon;
        this.gson = Utils.GetGson();
        this.timerHandler.postDelayed(this.timerRunnable, 0L);
        try {
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
            String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_CHAT_PORT_IN + "?imei=" + this.imei + "&groupId=" + idGroup + "&API_KEY=" + API_KEY + "&clientName=" + this.name;
            this.socket = Socket.Builder.with(url).build().connect();
            this.webSocketConnection();
        }
        catch (Exception ex) {
            Log.e((String)this.TAG, (String)("error en webSocketConnection: " + ex.getMessage()));
        }
        this.setAdapter();
    }

    private void setAdapter() {
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.context);
        linearLayoutManager.setStackFromEnd(true);
        this.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.setHasFixedSize(true);
        this.setAdapter(new CustomAdapterBubble(this.lsChat, this.context, this.mActivity));
        this.getLayoutManager().scrollToPosition(this.getAdapter().getItemCount() - 1);
    }

    private void notifyItemInserted() {
        this.getAdapter().notifyItemInserted(this.lsChat.size() - 1);
        this.getLayoutManager().scrollToPosition(this.getAdapter().getItemCount() - 1);
    }

    private void webSocketConnection() {
        OkHttpClient clientCoinPrice = new OkHttpClient();
        String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_CHAT_PORT + "?imei=" + this.getIMEINumber() + "&groupId=" + this.idGroup + "&API_KEY=" + this.API_KEY + "&clientName=" + this.name;
        Log.e((String)this.TAG, (String)url);
        Request requestCoinPrice = new Request.Builder().url(url).build();
        WebSocketListener webSocketListenerCoinPrice = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                Log.e((String)ChatListView.this.TAG, (String)"onOpen");
            }

            public void onMessage(WebSocket webSocket, String text) {
                Log.e((String)ChatListView.this.TAG, (String)("MESSAGE String: " + text));
                try {
                    ChatListView.this.notificationMessage = text;
                    JSONObject jObject = new JSONObject(text);
                    ChatListView.this.from = new JSONObject(jObject.getString("data")).getString("from");
                    ChatListView.this.messageText = new JSONObject(jObject.getString("data")).getString("text");
                    ChatListView.this.dateTime = Utils.GetStringDate();
                    ChatListView.this.newMessage = true;
                }
                catch (Exception ex) {
                    Log.e((String)ChatListView.this.TAG, (String)ex.getMessage());
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                try {
                    Log.e((String)ChatListView.this.TAG, (String)("MESSAGE bytes: " + bytes.hex()));
                }
                catch (Exception ex) {
                    System.out.print(ex.getMessage());
                }
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(1000, null);
                webSocket.cancel();
                Log.e((String)ChatListView.this.TAG, (String)("CLOSE: " + code + " " + reason));
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            }
        };
        clientCoinPrice.newWebSocket(requestCoinPrice, webSocketListenerCoinPrice);
        clientCoinPrice.dispatcher().executorService().shutdown();
    }

    private String getIMEINumber() {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)this.context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }

    public void addNotification(String title, String text, String packageName, int resIcon, String notificationMessage) {
        PackageManager pmg = this.context.getPackageManager();
        String name = "";
        Intent LaunchIntent = null;
        try {
            if (pmg != null) {
                ApplicationInfo app = this.context.getPackageManager().getApplicationInfo(packageName, 0);
                name = (String)pmg.getApplicationLabel(app);
                LaunchIntent = pmg.getLaunchIntentForPackage(packageName);
            }
            Log.d((String)"intent.getExtras", (String)("Found!: " + name));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        NotificationManager mNotificationManager = (NotificationManager)this.context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26 && mNotificationManager.getNotificationChannel(Conf.FOREGROUND_CHANNEL_ID) == null) {
            int importance = 3;
            NotificationChannel channel = new NotificationChannel(Conf.FOREGROUND_CHANNEL_ID, (CharSequence)name, importance);
            channel.enableVibration(false);
            mNotificationManager.createNotificationChannel(channel);
        }
        Intent intent = LaunchIntent;
        intent.putExtra("notificationMessage", notificationMessage);
        intent.addFlags(0x34000000);
        PendingIntent pIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x40000000);
        NotificationCompat.Builder notificationBuilder = Build.VERSION.SDK_INT >= 26 ? new NotificationCompat.Builder(this.context, Conf.FOREGROUND_CHANNEL_ID) : new NotificationCompat.Builder(this.context);
        Uri uri = RingtoneManager.getDefaultUri((int)2);
        notificationBuilder.setSmallIcon(R.drawable.ic_launcher_round).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setCategory("msg").setContentIntent(pIntent).setSound(uri).setSmallIcon(resIcon).setAutoCancel(true);
        if (Build.VERSION.SDK_INT >= 21) {
            notificationBuilder.setVisibility(1);
        }
        mNotificationManager.notify(Conf.NOTIFICATION_ID_FOREGROUND_SERVICE, notificationBuilder.build());
        PowerManager pm = (PowerManager)this.context.getSystemService("power");
        boolean isScreenOn = pm.isScreenOn();
        Log.e((String)"screen on.........", (String)("" + isScreenOn));
        if (!isScreenOn) {
            PowerManager.WakeLock wl = pm.newWakeLock(805306394, this.TAG);
            wl.acquire(10000L);
            PowerManager.WakeLock wl_cpu = pm.newWakeLock(1, "MyCpuLock");
            wl_cpu.acquire(10000L);
        }
    }

    private boolean appInForeground(@NonNull Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List runningAppProcesses = activityManager.getRunningAppProcesses();
        if (runningAppProcesses == null) {
            return false;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcess : runningAppProcesses) {
            if (!runningAppProcess.processName.equals(context.getPackageName()) || runningAppProcess.importance != 100) continue;
            return true;
        }
        return false;
    }

    public void sendMessage(String from, String encryptedData, String dateTime, String type) {
        try {
            this.socket.sendOnOpen(type, "{\n    \"from\": \"" + from + "\",\n    \"text\": \"" + encryptedData + "\", \n    \"dateTime\": \"" + dateTime + "\" \n}");
            this.lsChat.add(new ChatModel(1L, (MessageModel)this.gson.fromJson(AESUtils.decText(encryptedData), MessageModel.class), Conf.LOCAL_USER, dateTime, true));
            this.notifyItemInserted();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callToBase64(MessageModel messageModel) {
        try {
            new CallTask(this.context, this).execute(new Object[]{messageModel});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onTaskCompleted(TaskMessage result) {
        try {
            if (result != null && result.getMessageModel() != null) {
                this.sendMessage(result.getMessageModel().getFrom(), AESUtils.encText(this.gson.toJson((Object)result.getMessageModel())), result.getMessageModel().getDate(), result.getMessageModel().getType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

