/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils.log;

import android.content.Context;
import com.shopgun.android.utils.FileUtils;
import com.shopgun.android.utils.ToStringUtils;
import com.shopgun.android.utils.log.Logger;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DiskLogger
implements Logger {
    public static final String TAG = DiskLogger.class.getSimpleName();
    public static final String DEF_LOG_DIR = "log";
    public static final String DEF_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss:SSSZ";
    public static final String LOG_FORMAT = "%s %1.1s/%s: %s";
    private File mFile;
    private int mMinLevel;
    private DateFormat mDateFormat;

    public DiskLogger(Context context, String fileName) {
        this(context, fileName, 3);
    }

    public DiskLogger(Context context, String fileName, int minLevel) {
        this(context, fileName, minLevel, new SimpleDateFormat(DEF_DATE_FORMAT, Locale.US));
    }

    public DiskLogger(Context context, String fileName, int minLevel, DateFormat dateFormat) {
        this(new File(FileUtils.getExtDirectory(context, true, DEF_LOG_DIR), fileName), minLevel, dateFormat);
    }

    public DiskLogger(File file, int minLevel, DateFormat dateFormat) {
        this.mFile = file;
        this.mMinLevel = minLevel;
        this.mDateFormat = dateFormat;
    }

    @Override
    public int v(String tag, String msg) {
        return this.write(2, new Date(), tag, msg, null);
    }

    @Override
    public int v(String tag, String msg, Throwable tr) {
        return this.write(2, new Date(), tag, msg, tr);
    }

    @Override
    public int d(String tag, String msg) {
        return this.write(3, new Date(), tag, msg, null);
    }

    @Override
    public int d(String tag, String msg, Throwable tr) {
        return this.write(3, new Date(), tag, msg, tr);
    }

    @Override
    public int i(String tag, String msg) {
        return this.write(4, new Date(), tag, msg, null);
    }

    @Override
    public int i(String tag, String msg, Throwable tr) {
        return this.write(4, new Date(), tag, msg, tr);
    }

    @Override
    public int w(String tag, String msg) {
        return this.write(5, new Date(), tag, msg, null);
    }

    @Override
    public int w(String tag, String msg, Throwable tr) {
        return this.write(5, new Date(), tag, msg, tr);
    }

    @Override
    public int e(String tag, String msg) {
        return this.write(6, new Date(), tag, msg, null);
    }

    @Override
    public int e(String tag, String msg, Throwable tr) {
        return this.write(6, new Date(), tag, msg, tr);
    }

    synchronized int write(int logLevel, Date date, String tag, String msg, Throwable tr) {
        String message;
        if (logLevel < this.mMinLevel || msg == null) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        String d = this.mDateFormat.format(date);
        String l = ToStringUtils.logLevelToString(logLevel);
        sb.append(String.format(Locale.US, LOG_FORMAT, d, l, tag, msg)).append("\n");
        if (tr != null) {
            sb.append(tr.getMessage());
            for (StackTraceElement ste : tr.getStackTrace()) {
                sb.append("- ").append(String.valueOf(ste)).append("\n");
            }
        }
        return FileUtils.writeToFile(this.mFile, message = sb.toString(), true) ? message.getBytes().length : 0;
    }
}

