/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewPropertyAnimator;
import androidx.annotation.RequiresApi;
import com.shopgun.android.utils.Tag;
import java.util.concurrent.atomic.AtomicInteger;

public class ViewUtils {
    public static final String TAG = Tag.from(ViewUtils.class);
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static final int DEF_FADE_DURATION = 150;

    private ViewUtils() {
    }

    public static boolean isClick(int actionId, KeyEvent event) {
        return actionId == 6 || actionId == 3 || actionId == 0 || event != null && event.getAction() == 0 && event.getKeyCode() == 66;
    }

    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            return ViewUtils.generateViewIdPreJellyBeans();
        }
        return View.generateViewId();
    }

    private static int generateViewIdPreJellyBeans() {
        int newValue;
        int result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
            newValue = 1;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public static Bitmap viewToBitmap(View view, int defBackgroundColor) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable drawable = view.getBackground();
        if (drawable != null) {
            drawable.draw(canvas);
        } else {
            canvas.drawColor(defBackgroundColor);
        }
        view.draw(canvas);
        return bitmap;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        Bitmap bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static boolean isVisible(View view) {
        return view.getVisibility() == 0;
    }

    public static boolean isGone(View view) {
        return view.getVisibility() == 8;
    }

    public static boolean isInvisible(View view) {
        return view.getVisibility() == 4;
    }

    @RequiresApi(api=12)
    public static AnimationSet crossFadeViews(View in, View out) {
        return ViewUtils.crossFadeViews(in, out, 150);
    }

    @RequiresApi(api=12)
    public static AnimationSet crossFadeViews(View in, View out, int duration) {
        ViewPropertyAnimator inAnimator = ViewUtils.fadeIn(in, duration);
        ViewPropertyAnimator outAnimator = ViewUtils.fadeOut(out, duration);
        return new AnimationSet(inAnimator, outAnimator);
    }

    @RequiresApi(api=12)
    public static ViewPropertyAnimator fadeIn(View in) {
        return ViewUtils.fadeIn(in, 150);
    }

    @RequiresApi(api=12)
    public static ViewPropertyAnimator fadeIn(View in, int duration) {
        in.setAlpha(0.0f);
        in.setVisibility(0);
        ViewPropertyAnimator animator = in.animate();
        animator.alpha(1.0f).setDuration((long)duration).setListener(null);
        return animator;
    }

    @RequiresApi(api=12)
    public static ViewPropertyAnimator fadeOut(View out) {
        return ViewUtils.fadeOut(out, 150);
    }

    @RequiresApi(api=12)
    public static ViewPropertyAnimator fadeOut(final View out, int duration) {
        ViewPropertyAnimator animator = out.animate();
        animator.alpha(0.0f).setDuration((long)duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                out.setVisibility(8);
                out.setAlpha(1.0f);
            }
        });
        return animator;
    }

    public static class AnimationSet {
        private ViewPropertyAnimator mInAnimator;
        private ViewPropertyAnimator mOutAnimator;

        public AnimationSet() {
        }

        public AnimationSet(ViewPropertyAnimator inAnimator, ViewPropertyAnimator outAnimator) {
            this.mInAnimator = inAnimator;
            this.mOutAnimator = outAnimator;
        }

        @RequiresApi(api=14)
        public void cancel() {
            AnimationSet.cancel(this.mInAnimator);
            AnimationSet.cancel(this.mOutAnimator);
        }

        public ViewPropertyAnimator getInAnimator() {
            return this.mInAnimator;
        }

        public ViewPropertyAnimator getOutAnimator() {
            return this.mOutAnimator;
        }

        @RequiresApi(api=14)
        private static void cancel(ViewPropertyAnimator animator) {
            if (animator != null) {
                animator.cancel();
            }
        }
    }
}

