/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.shopgun.android.utils.Tag;
import java.util.Locale;

public class UnitUtils {
    public static final String TAG = Tag.from(UnitUtils.class);

    private UnitUtils() {
    }

    public static float dpToPx(float dp, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return dp * metrics.density;
    }

    public static int dpToPx(int dp, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return (int)((float)dp * metrics.density);
    }

    public static float pxToDp(float px, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return px / metrics.density;
    }

    public static int pxToDp(int px, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return (int)((float)px / metrics.density);
    }

    public static float spToPx(float sp, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)metrics);
    }

    public static int spToPx(int sp, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)metrics);
    }

    public static float pxToSp(float px, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return px / metrics.scaledDensity;
    }

    public static int pxToSp(int px, Context ctx) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return px / (int)metrics.scaledDensity;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.US, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

