/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Locale;

public class PolygonF
implements Parcelable {
    private RectF mBounds;
    private float mMinX;
    private float mMinY;
    private float mMaxX;
    private float mMaxY;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    public static final Parcelable.Creator<PolygonF> CREATOR = new Parcelable.Creator<PolygonF>(){

        public PolygonF createFromParcel(Parcel source) {
            return new PolygonF(source);
        }

        public PolygonF[] newArray(int size) {
            return new PolygonF[size];
        }
    };

    public PolygonF() {
        this(10);
    }

    public PolygonF(int size) {
        this(new float[size], new float[size], 0);
    }

    public PolygonF(float[] xpoints, float[] ypoints) {
        this(xpoints, ypoints, xpoints.length);
    }

    public PolygonF(float[] xpoints, float[] ypoints, int npoints) {
        if (xpoints.length != ypoints.length) {
            throw new IllegalArgumentException("xpoints.length!=ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = xpoints;
        this.ypoints = ypoints;
    }

    public PolygonF(PolygonF polygon) {
        this(Arrays.copyOf(polygon.xpoints, polygon.xpoints.length), Arrays.copyOf(polygon.ypoints, polygon.ypoints.length), polygon.npoints);
    }

    public boolean contains(float x, float y) {
        boolean inside = false;
        int i = 0;
        int j = this.npoints - 1;
        while (i < this.npoints) {
            if (this.ypoints[i] > y != this.ypoints[j] > y && x < (this.xpoints[j] - this.xpoints[i]) * (y - this.ypoints[i]) / (this.ypoints[j] - this.ypoints[i]) + this.xpoints[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public RectF getBounds() {
        if (this.npoints == 0) {
            return new RectF();
        }
        if (this.mBounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.mBounds;
    }

    void calculateBounds(float[] xpoints, float[] ypoints, int npoints) {
        this.mMinX = Float.MAX_VALUE;
        this.mMinY = Float.MAX_VALUE;
        this.mMaxX = Float.MIN_VALUE;
        this.mMaxY = Float.MIN_VALUE;
        for (int i = 0; i < npoints; ++i) {
            float x = xpoints[i];
            this.mMinX = Math.min(this.mMinX, x);
            this.mMaxX = Math.max(this.mMaxX, x);
            float y = ypoints[i];
            this.mMinY = Math.min(this.mMinY, y);
            this.mMaxY = Math.max(this.mMaxY, y);
        }
        this.mBounds = new RectF(this.mMinX, this.mMinY, this.mMaxX, this.mMaxY);
    }

    public void addPoint(float x, float y) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.mBounds = null;
    }

    public void addPoint(double x, double y) {
        this.addPoint((float)x, (float)y);
    }

    public PolygonF duplicate() {
        return new PolygonF(Arrays.copyOf(this.xpoints, this.xpoints.length), Arrays.copyOf(this.ypoints, this.ypoints.length), this.npoints);
    }

    public double getLength(boolean isLine) {
        double dy;
        double dx;
        double length = 0.0;
        for (int i = 0; i < this.npoints - 1; ++i) {
            dx = this.xpoints[i + 1] - this.xpoints[i];
            dy = this.ypoints[i + 1] - this.ypoints[i];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        if (!isLine) {
            dx = this.xpoints[0] - this.xpoints[this.npoints - 1];
            dy = this.ypoints[0] - this.ypoints[this.npoints - 1];
            length += Math.sqrt(dx * dx + dy * dy);
        }
        return length;
    }

    public String toString() {
        return "PolygonF(" + this.toShortString() + ")";
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        String f = "[%.2f,%.2f]";
        for (int i = 0; i < this.npoints; ++i) {
            sb.append(String.format(Locale.US, f, Float.valueOf(this.xpoints[i]), Float.valueOf(this.ypoints[i])));
        }
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mBounds, flags);
        dest.writeInt(this.npoints);
        dest.writeFloatArray(this.xpoints);
        dest.writeFloatArray(this.ypoints);
    }

    protected PolygonF(Parcel in) {
        this.mBounds = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.npoints = in.readInt();
        this.xpoints = in.createFloatArray();
        this.ypoints = in.createFloatArray();
    }
}

