/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import androidx.core.content.ContextCompat;
import java.util.concurrent.TimeUnit;

public class LocationUtils {
    public static Location getLastKnownLocation(Context context) {
        LocationManager manager;
        Location bestLastKnown = null;
        if (LocationUtils.hasAnyLocationPermission(context) && (manager = (LocationManager)context.getSystemService("location")) != null) {
            for (String provider : manager.getProviders(true)) {
                Location l = manager.getLastKnownLocation(provider);
                if (!LocationUtils.isValidAndBetter(l, bestLastKnown)) continue;
                bestLastKnown = l;
            }
        }
        return bestLastKnown;
    }

    public static boolean hasAnyLocationPermission(Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
    }

    public static boolean isValidAndBetter(Location newLocation, Location current) {
        return LocationUtils.isValidLocation(newLocation) && LocationUtils.isBetterLocation(newLocation, current);
    }

    public static boolean isValidLocation(Location l) {
        return l != null && l.getLatitude() != 0.0 && l.getLongitude() != 0.0;
    }

    public static boolean isBetterLocation(Location newLocation, Location currentLocation) {
        boolean isNewer;
        if (currentLocation == null) {
            return true;
        }
        if (newLocation == null) {
            return false;
        }
        long timeDelta = newLocation.getTime() - currentLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > TimeUnit.MINUTES.toMillis(3L);
        boolean isSignificantlyOlder = timeDelta < -TimeUnit.MINUTES.toMillis(3L);
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        float distance = newLocation.distanceTo(currentLocation);
        if (distance < 1.0f) {
            return false;
        }
        float distVsAccuracy = distance - newLocation.getAccuracy();
        if (distVsAccuracy > 0.0f) {
            return true;
        }
        int accuracyDelta = (int)(newLocation.getAccuracy() - currentLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = LocationUtils.isSameProvider(newLocation.getProvider(), currentLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    public static boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }
}

