/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.content.Context;
import android.os.Environment;
import androidx.core.content.ContextCompat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class FileUtils {
    public static final String TAG = FileUtils.class.getSimpleName();

    private FileUtils() {
    }

    public static File getExtDirectory(Context context, boolean preferExternal, String dir) {
        File cacheDir = null;
        if (preferExternal && "mounted".equals(Environment.getExternalStorageState()) && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            cacheDir = FileUtils.getExternalDir(context, dir);
        }
        if (cacheDir == null) {
            cacheDir = context.getCacheDir();
        }
        if (cacheDir == null) {
            String filesDir = context.getFilesDir().getPath();
            cacheDir = new File(filesDir + context.getPackageName() + "/" + dir + "/");
        }
        return cacheDir;
    }

    private static File getExternalDir(Context context, String dir) {
        File dataDir = new File(Environment.getExternalStorageDirectory(), "Android/data");
        File cacheDir = new File(new File(dataDir, context.getPackageName()), dir);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            return null;
        }
        return cacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeToFile(File file, String data, boolean append) {
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                boolean bl = false;
                return bl;
            }
            if (!file.exists() && !file.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            fos = new FileOutputStream(file, append);
            osw = new OutputStreamWriter(fos);
            bw = new BufferedWriter(osw);
            bw.write(data);
            bw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

