/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.shopgun.android.utils.Tag;
import com.shopgun.android.utils.enums.Orientation;

public class DisplayUtils {
    public static final String TAG = Tag.from(DisplayUtils.class);

    private DisplayUtils() {
    }

    public static int getScreenWidth(Context ctx) {
        return DisplayUtils.getDisplayMetrics((Context)ctx).widthPixels;
    }

    public static int getScreenHeight(Context ctx) {
        return DisplayUtils.getDisplayMetrics((Context)ctx).heightPixels;
    }

    private static WindowManager getWindowManager(Context ctx) {
        return (WindowManager)ctx.getSystemService("window");
    }

    private static DisplayMetrics getDisplayMetrics(Context ctx) {
        Display display = DisplayUtils.getWindowManager(ctx).getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        return outMetrics;
    }

    public static boolean isPortrait(Context ctx) {
        return Orientation.fromContext(ctx).isPortrait();
    }

    public static boolean isLandscape(Context ctx) {
        return Orientation.fromContext(ctx).isLandscape();
    }
}

