/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils.log;

import android.util.Log;
import com.shopgun.android.utils.log.Logger;

public class LogCatLogger
implements Logger {
    private static final String CHUNK_FORMAT = "[chunk %s/%s] %s";
    private final int mMinLevel;

    public LogCatLogger() {
        this(3);
    }

    public LogCatLogger(int minLevel) {
        this.mMinLevel = minLevel;
    }

    @Override
    public int v(String tag, String msg) {
        return this.log(2, tag, msg);
    }

    @Override
    public int v(String tag, String msg, Throwable tr) {
        return this.log(2, tag, msg, tr);
    }

    @Override
    public int d(String tag, String msg) {
        return this.log(3, tag, msg);
    }

    @Override
    public int d(String tag, String msg, Throwable tr) {
        return this.log(3, tag, msg, tr);
    }

    @Override
    public int i(String tag, String msg) {
        return this.log(4, tag, msg);
    }

    @Override
    public int i(String tag, String msg, Throwable tr) {
        return this.log(4, tag, msg, tr);
    }

    @Override
    public int w(String tag, String msg) {
        return this.log(5, tag, msg);
    }

    @Override
    public int w(String tag, String msg, Throwable tr) {
        return this.log(5, tag, msg, tr);
    }

    @Override
    public int e(String tag, String msg) {
        return this.log(6, tag, msg);
    }

    @Override
    public int e(String tag, String msg, Throwable tr) {
        return this.log(6, tag, msg, tr);
    }

    private int log(int level, String tag, String msg) {
        return this.log(level, tag, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int log(int level, String tag, String msg, Throwable tr) {
        if (level < this.mMinLevel) {
            return 0;
        }
        Class<LogCatLogger> clazz = LogCatLogger.class;
        synchronized (LogCatLogger.class) {
            if (msg.length() > 4000) {
                int bytesWritten = 0;
                int chunkCount = msg.length() / 4000;
                for (int i = 0; i <= chunkCount; ++i) {
                    int max = 4000 * (i + 1);
                    int end = max >= msg.length() ? msg.length() : max;
                    String msgChunk = String.format(CHUNK_FORMAT, i, chunkCount, msg.substring(4000 * i, end));
                    if (i == chunkCount && tr != null) {
                        bytesWritten += this.logToLogCat(level, tag, msgChunk, tr);
                        continue;
                    }
                    bytesWritten += this.logToLogCat(level, tag, msgChunk);
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return bytesWritten;
            }
            if (tr != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this.logToLogCat(level, tag, msg, tr);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return this.logToLogCat(level, tag, msg);
        }
    }

    private int logToLogCat(int level, String tag, String msg) {
        switch (level) {
            case 2: {
                return Log.v((String)tag, (String)msg);
            }
            case 3: {
                return Log.d((String)tag, (String)msg);
            }
            case 4: {
                return Log.i((String)tag, (String)msg);
            }
            case 5: {
                return Log.w((String)tag, (String)msg);
            }
            case 6: {
                return Log.e((String)tag, (String)msg);
            }
        }
        return 0;
    }

    private int logToLogCat(int level, String tag, String msg, Throwable tr) {
        switch (level) {
            case 2: {
                return Log.v((String)tag, (String)msg, (Throwable)tr);
            }
            case 3: {
                return Log.d((String)tag, (String)msg, (Throwable)tr);
            }
            case 4: {
                return Log.i((String)tag, (String)msg, (Throwable)tr);
            }
            case 5: {
                return Log.w((String)tag, (String)msg, (Throwable)tr);
            }
            case 6: {
                return Log.e((String)tag, (String)msg, (Throwable)tr);
            }
        }
        return 0;
    }
}

