/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.annotation.SuppressLint;
import com.shopgun.android.utils.Tag;
import java.util.regex.Pattern;

public class TextUtils {
    public static final String TAG = Tag.from(TextUtils.class);

    public static String join(int[] tokens) {
        return TextUtils.join((CharSequence)",", tokens);
    }

    public static String join(CharSequence delimiter, int[] tokens) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = tokens;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer token = nArray[i];
            if (sb.length() != 0) {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String join(float[] tokens) {
        return TextUtils.join((CharSequence)",", tokens);
    }

    public static String join(CharSequence delimiter, float[] tokens) {
        StringBuilder sb = new StringBuilder();
        float[] fArray = tokens;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float token = Float.valueOf(fArray[i]);
            if (sb.length() != 0) {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String join(Object[] tokens) {
        return android.text.TextUtils.join((CharSequence)",", (Object[])tokens);
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        return android.text.TextUtils.join((CharSequence)delimiter, (Object[])tokens);
    }

    public static String join(Iterable tokens) {
        return android.text.TextUtils.join((CharSequence)",", (Iterable)tokens);
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        return android.text.TextUtils.join((CharSequence)delimiter, (Iterable)tokens);
    }

    public static String[] split(String text, String expression) {
        return android.text.TextUtils.split((String)text, (String)expression);
    }

    public static String[] split(String text, Pattern pattern) {
        return android.text.TextUtils.split((String)text, (Pattern)pattern);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toCamelCaseIfAllUppercase(String word, String splitChar) {
        if (TextUtils.isEmpty(word)) {
            return word;
        }
        if (word.toUpperCase().equals(word)) {
            return TextUtils.toCamelCase(word, splitChar);
        }
        return word;
    }

    public static String toCamelCase(String word, String split) {
        if (TextUtils.isEmpty(word)) {
            return word;
        }
        split = split == null ? " " : split;
        StringBuilder sb = new StringBuilder(word.length());
        for (String s : word.split(split)) {
            if (sb.length() > 0) {
                sb.append(split);
            }
            sb.append(TextUtils.toCamelCase(s));
        }
        return sb.toString();
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toCamelCase(String word) {
        if (TextUtils.isEmpty(word)) {
            return word;
        }
        char first = Character.toUpperCase(word.charAt(0));
        if (word.length() == 1) {
            return Character.toString(first);
        }
        return first + word.substring(1).toLowerCase();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }
}

