/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class SharedPreferencesUtils {
    private SharedPreferencesUtils() {
    }

    public static String getDefaultSharedPreferencesName(Context context) {
        return context.getPackageName() + "_preferences";
    }

    public static void copySharedPreferences(SharedPreferences fromPreferences, SharedPreferences toPreferences) {
        SharedPreferencesUtils.copySharedPreferences(fromPreferences, toPreferences, true);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static void copySharedPreferences(SharedPreferences fromPreferences, SharedPreferences toPreferences, boolean clear) {
        SharedPreferences.Editor editor = toPreferences.edit();
        if (clear) {
            editor.clear();
        }
        SharedPreferencesUtils.copySharedPreferences(fromPreferences, editor);
        editor.commit();
    }

    @TargetApi(value=11)
    public static void copySharedPreferences(SharedPreferences fromPreferences, SharedPreferences.Editor toEditor) {
        for (Map.Entry entry : fromPreferences.getAll().entrySet()) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof String) {
                toEditor.putString(key, (String)value);
                continue;
            }
            if (value instanceof Set) {
                toEditor.putStringSet(key, (Set)value);
                continue;
            }
            if (value instanceof Integer) {
                toEditor.putInt(key, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                toEditor.putLong(key, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                toEditor.putFloat(key, ((Float)value).floatValue());
                continue;
            }
            if (!(value instanceof Boolean)) continue;
            toEditor.putBoolean(key, ((Boolean)value).booleanValue());
        }
    }

    public static void clearSharedPreferences(Context ctx) {
        File dir = new File(ctx.getFilesDir().getParent() + "/shared_prefs/");
        String[] children = dir.list();
        for (int i = 0; i < children.length; ++i) {
            ctx.getSharedPreferences(children[i].replace(".xml", ""), 0).edit().clear().commit();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        for (int i = 0; i < children.length; ++i) {
            new File(dir, children[i]).delete();
        }
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public static boolean moveSharedPreferences(Context ctx, String fromPreferencesName, String toPreferencesName) {
        if (fromPreferencesName == null || toPreferencesName == null) {
            throw new IllegalArgumentException("Filenames cannot be null");
        }
        String fromFileName = fromPreferencesName + ".xml";
        String toFileName = toPreferencesName + ".xml";
        String prefsPath = ctx.getFilesDir().getParent() + "/shared_prefs/";
        File fromPrefsFile = new File(prefsPath + fromFileName);
        if (fromPrefsFile.exists()) {
            SharedPreferences fromPrefs = ctx.getSharedPreferences(fromPreferencesName, 0);
            fromPrefs.edit().commit();
            File toPrefsFile = new File(prefsPath + toFileName);
            if (toPrefsFile.exists()) {
                SharedPreferences toPrefs = ctx.getSharedPreferences(toPreferencesName, 0);
                SharedPreferencesUtils.copySharedPreferences(fromPrefs, toPrefs, false);
                return fromPrefsFile.delete();
            }
            return fromPrefsFile.renameTo(toPrefsFile);
        }
        return false;
    }
}

