/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import com.shopgun.android.utils.Tag;

public class PackageUtils {
    public static final String TAG = Tag.from(PackageUtils.class);

    private PackageUtils() {
    }

    public static boolean isInstalled(Context ctx, String packageName) {
        try {
            PackageUtils.getPackageInfo(ctx, packageName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static void openGooglePlay(Context ctx) throws ActivityNotFoundException {
        PackageUtils.openGooglePlay(ctx, ctx.getPackageName());
    }

    public static void openGooglePlay(Context ctx, String packageName) throws ActivityNotFoundException {
        try {
            PackageUtils.startPlay(ctx, "market://details?id=" + packageName);
        }
        catch (ActivityNotFoundException exception) {
            PackageUtils.startPlay(ctx, "http://play.google.com/store/apps/details?id=" + packageName);
        }
    }

    public static void startPlay(Context ctx, String uri) throws ActivityNotFoundException {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        intent.setFlags(0x50000000);
        ctx.startActivity(intent);
    }

    public static String getVersionName(Context c) throws ContextPackageNameNotFoundException {
        return PackageUtils.getPackageInfo((Context)c).versionName;
    }

    public static int getVersionCode(Context c) throws ContextPackageNameNotFoundException {
        return PackageUtils.getPackageInfo((Context)c).versionCode;
    }

    public static PackageInfo getPackageInfo(Context c) throws ContextPackageNameNotFoundException {
        return PackageUtils.getPackageInfo(c, 0);
    }

    public static PackageInfo getPackageInfo(Context c, int flags) throws ContextPackageNameNotFoundException {
        try {
            return PackageUtils.getPackageInfo(c, c.getPackageName(), flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new ContextPackageNameNotFoundException(c, e);
        }
    }

    public static Bundle getMetaData(Context c) {
        return PackageUtils.getApplicationInfo((Context)c, (int)128).metaData;
    }

    public static ApplicationInfo getApplicationInfo(Context c) throws ContextPackageNameNotFoundException {
        try {
            return PackageUtils.getApplicationInfo(c, c.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new ContextPackageNameNotFoundException(c, e);
        }
    }

    public static ApplicationInfo getApplicationInfo(Context c, int flags) throws ContextPackageNameNotFoundException {
        try {
            return PackageUtils.getApplicationInfo(c, c.getPackageName(), flags);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new ContextPackageNameNotFoundException(c, e);
        }
    }

    public static PackageInfo getPackageInfo(Context c, String packageName, int flags) throws PackageManager.NameNotFoundException {
        return c.getPackageManager().getPackageInfo(packageName, flags);
    }

    public static ApplicationInfo getApplicationInfo(Context c, String packageName, int flags) throws PackageManager.NameNotFoundException {
        return c.getPackageManager().getApplicationInfo(packageName, flags);
    }

    public static class ContextPackageNameNotFoundException
    extends RuntimeException {
        public ContextPackageNameNotFoundException(Context c, PackageManager.NameNotFoundException e) {
            this(c.getPackageName(), e);
        }

        public ContextPackageNameNotFoundException(String packageName, PackageManager.NameNotFoundException e) {
            super("The context package name (" + packageName + ") couldn't be found, WTF.", (Throwable)e);
        }
    }
}

