/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.support.annotation.NonNull;
import com.shopgun.android.utils.Tag;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static final String TAG = Tag.from(HashUtils.class);
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HashUtils() {
    }

    public static String sha256(@NonNull String string) {
        return HashUtils.digest(string, "SHA-256", "UTF-8");
    }

    public static String md5(@NonNull String string) {
        return HashUtils.digest(string, "MD5", "UTF-8");
    }

    private static String digest(String string, String digestAlgo, String encoding) {
        try {
            MessageDigest digester = MessageDigest.getInstance(digestAlgo);
            digester.update(string.getBytes(encoding));
            return HashUtils.hex(digester.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String hex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int value = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_CHARS[value >>> 4];
            hexChars[i * 2 + 1] = HEX_CHARS[value & 0xF];
        }
        return new String(hexChars);
    }
}

