/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import com.shopgun.android.utils.R;
import com.shopgun.android.utils.Tag;
import java.util.List;

public class DeviceUtils {
    public static final String TAG = Tag.from(DeviceUtils.class);

    private DeviceUtils() {
    }

    public static boolean isTablet(Context ctx) {
        return ctx.getResources().getBoolean(R.bool.isTablet);
    }

    public static boolean hasGPSSensor(Context context) {
        LocationManager mgr = (LocationManager)context.getSystemService("location");
        if (mgr == null) {
            return false;
        }
        List providers = mgr.getAllProviders();
        return providers != null && providers.contains("gps");
    }

    public static String getRadio() {
        return Build.getRadioVersion();
    }

    public static String getBuildVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getManufacturer() {
        return DeviceUtils.capitalize(Build.MANUFACTURER);
    }

    public static String getModel() {
        return Build.MODEL == null ? null : Build.MODEL.replace(Build.MANUFACTURER, "").trim();
    }

    public static String getManufacturerAndModel() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        model = model.startsWith(manufacturer) ? DeviceUtils.capitalize(model) : DeviceUtils.capitalize(manufacturer) + " " + model;
        return model;
    }

    private static String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }
}

