/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import com.shopgun.android.utils.ISO8601Utils;
import com.shopgun.android.utils.Tag;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateUtils {
    public static final String TAG = Tag.from(DateUtils.class);
    private static final long DAY_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);

    private DateUtils() {
    }

    public static boolean isMidnight(Date date) {
        return DateUtils.isMidnight(date, 0L, 0L);
    }

    public static boolean isMidnight(Date date, long epsilon) {
        return DateUtils.isMidnight(date, epsilon, epsilon);
    }

    public static boolean isMidnight(Date date, long epsilonToMidnight, long epsilonAfterMidnight) {
        long remainder = DateUtils.getTimeOfDayWithTimeZone(date) % DAY_IN_MILLIS;
        return DAY_IN_MILLIS - epsilonToMidnight <= remainder || remainder <= epsilonAfterMidnight;
    }

    public static long getTimeOfDayWithTimeZone(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int h = c.get(11);
        int m = c.get(12);
        int s = c.get(13);
        return TimeUnit.HOURS.toMillis(h) + TimeUnit.MINUTES.toMillis(m) + TimeUnit.SECONDS.toMillis(s);
    }

    public static Date roundTime(Date date) {
        if (date != null) {
            date.setTime(1000L * (date.getTime() / 1000L));
        }
        return date;
    }

    public static Date parse(String date) throws ParseException {
        return ISO8601Utils.parse(date, new ParsePosition(0));
    }

    public static String format(Date date) {
        return ISO8601Utils.format(date);
    }

    public static String format(Date date, boolean millis) {
        return ISO8601Utils.format(date, millis);
    }

    public static String format(Date date, boolean millis, TimeZone tz) {
        return ISO8601Utils.format(date, millis, tz);
    }
}

