/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.utils.Utils;
import java.util.List;
import org.json.JSONObject;

public class PrettyPrint {
    public static final String TAG = Constants.getTag(PrettyPrint.class);

    public static void printItems(String name, List<ShoppinglistItem> items) {
        StringBuilder sb = new StringBuilder();
        for (ShoppinglistItem sli : items) {
            sb.append(PrettyPrint.shoppinglistItemToString(sli)).append("\n");
        }
        SgnLog.d(TAG, name + "\n" + sb.toString());
    }

    public static void printItem(String name, ShoppinglistItem sli) {
        SgnLog.d(TAG, String.format("%s - %s", name, PrettyPrint.shoppinglistItemToString(sli)));
    }

    public static String shoppinglistItemToString(ShoppinglistItem sli) {
        String id2 = sli.getId().substring(0, 8);
        String prev = sli.getPreviousId() == null ? "null" : sli.getPreviousId().substring(0, 8);
        String title = sli.getDescription();
        if (title.length() > 8) {
            title = title.substring(0, 8);
        }
        String resp = "item[%-8s] prev[%s] id[%s] modified[%s]";
        resp = String.format(resp, title, prev, id2, Utils.dateToString(sli.getModified()));
        return resp;
    }

    public static void printResponse(String tag, String name, JSONObject response, ShopGunError error) {
        if (response != null) {
            SgnLog.d(tag, name + " - " + response.toString());
        } else {
            SgnLog.d(tag, name + " - " + error.toJSON().toString());
        }
    }
}

