/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.model.interfaces.ICatalog;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IStore;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IUtils {
    private IUtils() {
    }

    public static Set<String> getIds(List<? extends IErn<?>> list) {
        HashSet<String> ids = new HashSet<String>(list.size());
        for (IErn<?> ern : list) {
            ids.add(ern.getId());
        }
        return ids;
    }

    public static Set<String> toErnSet(List<? extends IErn<?>> list) {
        HashSet<String> set = new HashSet<String>();
        for (IErn<?> ern : list) {
            set.add(ern.getErn());
        }
        return set;
    }

    public static Set<String> getStoreIds(List<? extends IStore<?>> list) {
        HashSet<String> ids = new HashSet<String>(list.size());
        for (IStore<?> is : list) {
            if (is.getStore() != null) continue;
            ids.add(is.getStoreId());
        }
        return ids;
    }

    public static Set<String> getDealerIds(List<? extends IDealer<?>> list) {
        HashSet<String> ids = new HashSet<String>(list.size());
        for (IDealer<?> is : list) {
            if (is.getDealer() != null) continue;
            ids.add(is.getDealerId());
        }
        return ids;
    }

    public static Set<String> getCatalogIds(List<? extends ICatalog<?>> list, boolean forceReplace) {
        HashSet<String> ids = new HashSet<String>(list.size());
        for (ICatalog<?> ic : list) {
            if (ic.getCatalog() != null && !forceReplace) continue;
            ids.add(ic.getCatalogId());
        }
        return ids;
    }
}

