/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.graphics.Bitmap;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Dimension;
import com.squareup.picasso.Transformation;

public class CatalogThumbTransformation
implements Transformation {
    public static final String TAG = CatalogThumbTransformation.class.getSimpleName();
    private static final float EPSILON = 0.001f;
    private Catalog mCatalog;

    public CatalogThumbTransformation(Catalog mCatalog) {
        this.mCatalog = mCatalog;
    }

    public Bitmap transform(Bitmap source) {
        int tmp;
        if (this.mCatalog == null) {
            return source;
        }
        Dimension d = this.mCatalog.getDimension();
        if (d == null || d.getWidth() == null || d.getHeight() == null) {
            return source;
        }
        double dimenWidth = d.getWidth();
        double dimenHeight = d.getHeight();
        int w = source.getWidth();
        int h = source.getHeight();
        int x = 0;
        int y = 0;
        float dimenRatio = (float)dimenHeight / (float)dimenWidth;
        float sourceRatio = (float)h / (float)w;
        if (Math.abs(dimenRatio - sourceRatio) < 0.001f) {
            return source;
        }
        if (dimenHeight > (double)sourceRatio) {
            tmp = (int)((double)h * (dimenWidth / dimenHeight));
            x = Math.abs(w - tmp) / 2;
            w = tmp;
        } else {
            tmp = (int)((double)w * (dimenHeight / dimenWidth));
            y = Math.abs(h - tmp) / 2;
            h = tmp;
        }
        try {
            Bitmap b = Bitmap.createBitmap((Bitmap)source, (int)x, (int)y, (int)w, (int)h);
            source.recycle();
            return b;
        }
        catch (Exception e) {
            SgnLog.e(TAG, "Unable to create a new Bitmap", e);
            return source;
        }
    }

    public String key() {
        return this.mCatalog.getErn() + "-image-thumb-crop";
    }
}

