/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.os.Handler;
import android.os.Looper;
import com.shopgun.android.sdk.Constants;
import java.util.concurrent.atomic.AtomicInteger;

public class ActivityCounter
implements Runnable {
    public static final String TAG = Constants.getTag(ActivityCounter.class);
    public static final int DELAY = 1000;
    private final Handler mHandler;
    private final int mDelay;
    private final AtomicInteger mCounter = new AtomicInteger(0);
    private final OnLifecycleEvent mListener;
    private boolean mAwaitingTermination = false;
    private final Object LOCK = new Object();

    public ActivityCounter(OnLifecycleEvent listener) {
        this(listener, 1000, new Handler(Looper.getMainLooper()));
    }

    public ActivityCounter(OnLifecycleEvent listener, int delay) {
        this(listener, delay, new Handler(Looper.getMainLooper()));
    }

    public ActivityCounter(OnLifecycleEvent listener, int delay, Handler handler) {
        this.mListener = listener;
        this.mDelay = delay < 0 ? 0 : delay;
        this.mHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.mCounter.getAndIncrement() == 0 && !this.mAwaitingTermination) {
                this.mListener.onPerformStart();
            }
            this.mHandler.removeCallbacks((Runnable)this);
            this.mAwaitingTermination = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mHandler.removeCallbacks((Runnable)this);
            if (this.mCounter.decrementAndGet() == 0) {
                this.mAwaitingTermination = true;
                if (this.mDelay <= 0) {
                    this.run();
                } else {
                    this.mHandler.postDelayed((Runnable)this, (long)this.mDelay);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.mCounter.get() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.LOCK;
        synchronized (object) {
            this.mHandler.removeCallbacks((Runnable)this);
            this.mAwaitingTermination = false;
            this.mCounter.set(0);
            this.mListener.onPerformStop();
        }
    }

    public static interface OnLifecycleEvent {
        public void onPerformStart();

        public void onPerformStop();
    }
}

