/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.Validator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class ValidatorTest
extends TestCase {
    public static final String TAG = Constants.getTag(ValidatorTest.class);

    public static void test() {
        SdkTest.start(TAG);
        ValidatorTest.testIsEmailVaild();
        ValidatorTest.testIsBirthYearValid();
        ValidatorTest.testIsGenderValid();
        ValidatorTest.testValidVersion();
    }

    public static void testIsEmailVaild() {
        String[] valid;
        String[] inValid;
        for (String s : inValid = new String[]{null, "", "@", "@@", "d@@h", "d@k@h", "@hvam", " @ ", "null", "danny@", " d@h.dk ", "d@h.dk ", " d@h.dk"}) {
            ValidatorTest.assertFalse((boolean)Validator.isEmailValid(s));
        }
        for (String s : valid = new String[]{"danny@hvam.dk", "d@h", "d @ h", "d@h.dk", "4321@fdsafd", "[]{}()@[]{}()", "\u2202\u2211\u02d9\u2206\u00b4\u222b\u2211@\u02d9\u00a8\u02c6\u2202\u2211\u2206"}) {
            ValidatorTest.assertTrue((boolean)Validator.isEmailValid(s));
        }
        SdkTest.logTest(TAG, "IsEmailValid");
    }

    public static void testIsBirthYearValid() {
        int i;
        Assert.assertFalse((boolean)Validator.isBirthyearValid(Integer.MIN_VALUE));
        for (i = -1000; i < 1900; ++i) {
            Assert.assertFalse((boolean)Validator.isBirthyearValid(i));
        }
        for (i = 1900; i < 2016; ++i) {
            Assert.assertTrue((boolean)Validator.isBirthyearValid(i));
        }
        for (i = 2016; i < 3000; ++i) {
            Assert.assertFalse((boolean)Validator.isBirthyearValid(i));
        }
        Assert.assertFalse((boolean)Validator.isBirthyearValid(Integer.MAX_VALUE));
        SdkTest.logTest(TAG, "IsBirthYesrValid");
    }

    public static void testIsGenderValid() {
        String[] valid;
        String[] inValid;
        for (String s : inValid = new String[]{null, "", "danny", "fe male", "  ma le  ", "males", "females"}) {
            ValidatorTest.assertFalse((boolean)Validator.isGenderValid(s));
        }
        for (String s : valid = new String[]{"  male  ", "  female  ", "female", "male"}) {
            ValidatorTest.assertTrue((boolean)Validator.isGenderValid(s));
        }
        SdkTest.logTest(TAG, "IsGenderValid");
    }

    public static void testValidVersion() {
        String[] valid = new String[]{"2.0.0", "2.0.0-rc.2", "2.0.0-rc.1", "1.0.0", "1.0.0-beta", "1.0.0-b", "1.0.0-beta", "1.0.0-chocolate", "1.0.0-15948", "1.0.0-rc-1"};
        String[] invalid = new String[]{null, "jens", "", ".", "v", "v.1", "v1.0", "v1.0.0", "1.", "1.0", "1.0.", "1.0.0.0", "v1.0.0-beta.2.2", "v1-beta"};
        for (String s : valid) {
            Assert.assertTrue((boolean)Validator.isAppVersionValid(s));
        }
        for (String s : invalid) {
            Assert.assertFalse((boolean)Validator.isAppVersionValid(s));
        }
        SdkTest.logTest(TAG, "ValidVersion");
    }
}

