/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Si;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;

public class UtilsTest {
    public static final String TAG = Constants.getTag(UtilsTest.class);
    public static final String REGEX_UUID = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";

    public static void test() {
        SdkTest.start(TAG);
        UtilsTest.testCreateUUID();
        UtilsTest.testMapToQueryString();
        UtilsTest.testRequestToUrlAndQueryString();
        UtilsTest.testIsSuccess();
        UtilsTest.testCopyParcelable();
    }

    public static void testCreateUUID() {
        String notUuid = "this should not match the REGEX_UUID";
        Assert.assertFalse((boolean)notUuid.matches(REGEX_UUID));
        String uuid = Utils.createUUID();
        Assert.assertTrue((boolean)uuid.matches(REGEX_UUID));
        String otherUuid = Utils.createUUID();
        Assert.assertTrue((boolean)otherUuid.matches(REGEX_UUID));
        Assert.assertNotSame((Object)uuid, (Object)otherUuid);
        otherUuid = otherUuid.replace("a", "2").replace("b", "2").replace("c", "2").replace("d", "2").replace("e", "2").replace("f", "2");
        Assert.assertTrue((boolean)otherUuid.matches(REGEX_UUID));
        String uuidFake = "83g24023-3225-4392-9362-332619620638";
        Assert.assertFalse((boolean)uuidFake.matches(REGEX_UUID));
        SdkTest.logTest(TAG, "CreateUUID");
    }

    public static void testMapToQueryString() {
        String UTF8 = "utf-8";
        String expected = "";
        String actual = Utils.mapToQueryString(null, null);
        Assert.assertEquals((String)expected, (String)actual);
        actual = Utils.mapToQueryString(null, UTF8);
        Assert.assertEquals((String)expected, (String)actual);
        HashMap<String, String> map = new HashMap<String, String>();
        actual = Utils.mapToQueryString(map, UTF8);
        Assert.assertEquals((String)expected, (String)actual);
        map.put("b", "blue");
        map.put("a", "red");
        map.put("d", "green");
        actual = Utils.mapToQueryString(map, null);
        String expectedFalse = "b=blue&a=red&d=green";
        Assert.assertNotSame((Object)expectedFalse, (Object)actual);
        expected = "a=red&b=blue&d=green";
        Assert.assertEquals((String)expected, (String)actual);
        actual = Utils.mapToQueryString(map, "not utf-8");
        expectedFalse = "b=blue&a=red&d=green";
        Assert.assertNotSame((Object)expectedFalse, (Object)actual);
        expected = "a=red&b=blue&d=green";
        Assert.assertEquals((String)expected, (String)actual);
        actual = Utils.mapToQueryString(map, UTF8);
        expectedFalse = "b=blue&a=red&d=green";
        Assert.assertNotSame((Object)expectedFalse, (Object)actual);
        expected = "a=red&b=blue&d=green";
        Assert.assertEquals((String)expected, (String)actual);
        SdkTest.logTest(TAG, "MapToQueryString");
    }

    public static void testRequestToUrlAndQueryString() {
        String actual = Utils.requestToUrlAndQueryString(null);
        Assert.assertNull((Object)actual);
        JsonObjectRequest r = new JsonObjectRequest(null, null);
        actual = Utils.requestToUrlAndQueryString(r);
        Assert.assertNull((Object)actual);
        r = new JsonObjectRequest("http://eta.dk/", null);
        String expected = "http://eta.dk/";
        actual = Utils.requestToUrlAndQueryString(r);
        Assert.assertEquals((String)expected, (String)actual);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("b", "blue");
        map.put("a", "red");
        map.put("d", "green");
        r.getParameters().putAll(map);
        expected = "http://eta.dk/?a=red&b=blue&d=green";
        actual = Utils.requestToUrlAndQueryString(r);
        Assert.assertEquals((String)expected, (String)actual);
        SdkTest.logTest(TAG, "RequestToUrlAndQueryString");
    }

    public static void testIsSuccess() {
        int i;
        for (i = 200; i < 300; ++i) {
            Assert.assertTrue((boolean)Utils.isSuccess(i));
        }
        Assert.assertTrue((boolean)Utils.isSuccess(304));
        Assert.assertFalse((boolean)Utils.isSuccess(Integer.MIN_VALUE));
        for (i = -1; i < 200; ++i) {
            Assert.assertFalse((boolean)Utils.isSuccess(i));
        }
        for (i = 300; i < 304; ++i) {
            Assert.assertFalse((boolean)Utils.isSuccess(i));
        }
        for (i = 305; i < 600; ++i) {
            Assert.assertFalse((boolean)Utils.isSuccess(i));
        }
        Assert.assertFalse((boolean)Utils.isSuccess(Integer.MAX_VALUE));
        SdkTest.logTest(TAG, "IsGenderValid");
    }

    public static void testStringToDate() {
        String[] valid = new String[]{"1985-02-13T02:34:00+0000", "2100-03-03T13:37:00+0000", "2013-03-03T13:37:00+0000"};
        String[] invalid = new String[]{null, "", "danny", "1970", "1970-", "1970-00-01T00:00:00+0000", "1970-01-01T00:00:00", "1970-01-01T00:00:00-0000", "1970-01-01t00:00:00+0000", "0000-00-00T00:00:00+0000", "0000-00-00T00:00:00+0000", "9999-99-99T99:99:99+9999"};
        Date epoch = new Date(0L);
        Date actual = Utils.stringToDate("1970-01-01T00:00:00+0000");
        Assert.assertEquals((Object)epoch, (Object)actual);
        Calendar c = GregorianCalendar.getInstance();
        int offset = c.get(15) + c.get(16);
        for (String s : valid) {
            actual = Utils.stringToDate(s);
            Assert.assertNotSame((Object)epoch, (Object)actual);
            String tmp = Utils.dateToString(new Date(actual.getTime() - (long)offset));
            SgnLog.d(TAG, "in:  " + s);
            SgnLog.d(TAG, "out: " + tmp);
            Assert.assertEquals((String)s, (String)tmp);
        }
        for (String s : invalid) {
            actual = Utils.stringToDate(s);
            Assert.assertEquals((Object)epoch, (Object)actual);
        }
        SdkTest.logTest(TAG, "StringToDate");
    }

    public static void testDateToString() {
        Calendar c = GregorianCalendar.getInstance();
        String actual = Utils.dateToString(null);
        Assert.assertEquals((String)"1970-01-01T00:00:00+0000", (String)actual);
        actual = Utils.dateToString(new Date(0L));
        Assert.assertEquals((String)"1970-01-01T00:00:00+0000", (String)actual);
        c.set(1970, 1, 1, 0, 0, 0);
        actual = Utils.dateToString(c.getTime());
        Assert.assertEquals((String)"1970-01-01T00:00:00+0000", (String)actual);
        c.set(2013, 3, 3, 13, 37, 0);
        actual = Utils.dateToString(c.getTime());
        Assert.assertEquals((String)"2013-03-03T13:37:00+0000", (String)actual);
        c.set(2100, 12, 12, 23, 59, 59);
        actual = Utils.dateToString(c.getTime());
        Assert.assertEquals((String)"2100-12-12T23:59:59+0000", (String)actual);
        c.set(2000, 1, 1, 1, 1, 1);
        actual = Utils.dateToString(c.getTime());
        Assert.assertNotSame((Object)"2100-12-12T23:59:59+0000", (Object)actual);
        SdkTest.logTest(TAG, "DateToString");
    }

    public static void testCopyParcelable() {
        Si obj = new Si();
        Si copy = Utils.copyParcelable(obj, Si.CREATOR);
        Assert.assertNotSame((Object)obj, null);
        Assert.assertNotSame((Object)obj, (Object)copy);
        Assert.assertEquals((Object)obj, (Object)copy);
        copy = Utils.copyParcelable(obj, Si.CREATOR);
        Assert.assertNotSame((Object)obj, (Object)copy);
        Assert.assertEquals((Object)obj, (Object)copy);
        obj.setSymbol("USD");
        Assert.assertNotSame((Object)obj, (Object)copy);
        Assert.assertFalse((boolean)obj.equals(copy));
        copy = Utils.copyParcelable(obj, Si.CREATOR);
        Assert.assertNotSame((Object)obj, (Object)copy);
        Assert.assertEquals((Object)obj, (Object)copy);
        ArrayList<Si> list = new ArrayList<Si>();
        list.add(new Si());
        list.add(new Si());
        list.add(new Si());
        List<Si> listCopy = Utils.copyParcelable(list, Si.CREATOR);
        SdkTest.logTest(TAG, "Copy");
    }
}

