/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.content.res.Configuration;
import com.shopgun.android.sdk.pageflip.ReaderConfig;
import com.shopgun.android.sdk.pageflip.impl.SinglePageReaderConfig;
import com.shopgun.android.sdk.test.MethodNameHelper;
import com.shopgun.android.sdk.test.SdkTest;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;

public class SinglePageReaderConfigTest
extends TestCase {
    public static final String TAG = SinglePageReaderConfigTest.class.getSimpleName();

    public static void test() {
        SdkTest.start(TAG);
        SinglePageReaderConfig single = new SinglePageReaderConfig();
        single.setConfiguration(new Configuration());
        SinglePageReaderConfigTest.testIsLandscape(single);
        SinglePageReaderConfigTest.testPositionToPage(single);
        SinglePageReaderConfigTest.testPageToPosition(single);
    }

    public static void testIsLandscape(ReaderConfig r) {
        r.setConfiguration(null);
        SinglePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        Configuration c = new Configuration();
        c.orientation = 2;
        r.setConfiguration(c);
        SinglePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        c.orientation = 1;
        r.setConfiguration(c);
        SinglePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        c.orientation = 0;
        r.setConfiguration(c);
        SinglePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        c.orientation = 3;
        r.setConfiguration(c);
        SinglePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    public static void testPageToPosition(ReaderConfig r) {
        Configuration c = new Configuration();
        c.orientation = 2;
        r.setConfiguration(c);
        SinglePageReaderConfigTest.testPageToPosition(r, 1, 0);
        SinglePageReaderConfigTest.testPageToPosition(r, 2, 1);
        SinglePageReaderConfigTest.testPageToPosition(r, 3, 2);
        SinglePageReaderConfigTest.testPageToPosition(r, 4, 3);
        SinglePageReaderConfigTest.testPageToPosition(r, 5, 4);
        c.orientation = 1;
        r.setConfiguration(c);
        SinglePageReaderConfigTest.testPageToPosition(r, 1, 0);
        SinglePageReaderConfigTest.testPageToPosition(r, 2, 1);
        SinglePageReaderConfigTest.testPageToPosition(r, 3, 2);
        SinglePageReaderConfigTest.testPageToPosition(r, 4, 3);
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    private static void testPageToPosition(ReaderConfig config, int page, int expectedPos) {
        Assert.assertEquals((int)expectedPos, (int)config.pageToPosition(page));
    }

    public static void testPositionToPage(ReaderConfig r) {
        Configuration c = new Configuration();
        c.orientation = 2;
        r.setConfiguration(c);
        int PAGE_COUNT = 8;
        SinglePageReaderConfigTest.testPositionToPage(r, 0, PAGE_COUNT, new int[]{1});
        SinglePageReaderConfigTest.testPositionToPage(r, 1, PAGE_COUNT, new int[]{2});
        SinglePageReaderConfigTest.testPositionToPage(r, 2, PAGE_COUNT, new int[]{3});
        SinglePageReaderConfigTest.testPositionToPage(r, 3, PAGE_COUNT, new int[]{4});
        SinglePageReaderConfigTest.testPositionToPage(r, 4, PAGE_COUNT, new int[]{5});
        c.orientation = 1;
        r.setConfiguration(c);
        PAGE_COUNT = 4;
        SinglePageReaderConfigTest.testPositionToPage(r, 0, PAGE_COUNT, new int[]{1});
        SinglePageReaderConfigTest.testPositionToPage(r, 1, PAGE_COUNT, new int[]{2});
        SinglePageReaderConfigTest.testPositionToPage(r, 2, PAGE_COUNT, new int[]{3});
        SinglePageReaderConfigTest.testPositionToPage(r, 3, PAGE_COUNT, new int[]{4});
        SinglePageReaderConfigTest.testPositionToPage(r, 4, PAGE_COUNT, new int[]{5});
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    private static void testPositionToPage(ReaderConfig config, int pos, int pageCount, int[] expectedPages) {
        int[] pages = config.positionToPages(pos, pageCount);
        Assert.assertTrue((boolean)Arrays.equals(pages, expectedPages));
    }
}

