/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.test.ModelCreator;
import com.shopgun.android.sdk.test.SdkTest;
import junit.framework.Assert;

public class SerializationSpeedTest {
    public static final String TAG = Constants.getTag(SerializationSpeedTest.class);

    public static void test() {
        SerializationSpeedTest.test(100);
    }

    public static void test(int count) {
        SdkTest.start(TAG);
        SdkTest.logTest(TAG, "testing " + count + " iterations of serilization");
        long start = System.currentTimeMillis();
        SerializationSpeedTest.test(count, ModelCreator.getShoppinglist(), Shoppinglist.CREATOR);
        SerializationSpeedTest.print("Shoppinglist", count, start);
    }

    private static void print(String name, int count, long start) {
        long time = System.currentTimeMillis() - start;
        float avg = (float)time / (float)count;
        String format = "total: %sms, avg: %.2fms";
        SdkTest.logTest(TAG, String.format(format, time, Float.valueOf(avg)));
    }

    private static <T extends Parcelable> void test(int count, T obj, Parcelable.Creator<?> c) {
        for (int i = 0; i < count; ++i) {
            Parcel parcel = Parcel.obtain();
            obj.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            Object parceledObj = c.createFromParcel(parcel);
            Assert.assertEquals(obj, (Object)parceledObj);
        }
    }

    private static void testShoppinglistSerilization(int count) {
        Shoppinglist sl = ModelCreator.getShoppinglist();
        for (int i = 0; i < count; ++i) {
            Parcel parcel = Parcel.obtain();
            sl.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            Shoppinglist parceledObj = (Shoppinglist)Shoppinglist.CREATOR.createFromParcel(parcel);
        }
    }
}

