/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.content.Context;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.test.EnvironmentTest;
import com.shopgun.android.sdk.test.EventTest;
import com.shopgun.android.sdk.test.ExternalClientIdStoreTest;
import com.shopgun.android.sdk.test.JsonTest;
import com.shopgun.android.sdk.test.ListUtilsTest;
import com.shopgun.android.sdk.test.MaterialColorTest;
import com.shopgun.android.sdk.test.MaterialUtilsTest;
import com.shopgun.android.sdk.test.ModelTest;
import com.shopgun.android.sdk.test.PageflipTest;
import com.shopgun.android.sdk.test.PageflipUtilsTest;
import com.shopgun.android.sdk.test.ReaderConfigTest;
import com.shopgun.android.sdk.test.SerializationSpeedTest;
import com.shopgun.android.sdk.test.SgnLocationTest;
import com.shopgun.android.sdk.test.UtilsTest;
import com.shopgun.android.sdk.test.ValidatorTest;
import com.shopgun.android.sdk.test.VersionTest;

public class SdkTest {
    public static final String TAG = Constants.getTag(SdkTest.class);
    private static final boolean LOG = false;
    private static String mCurrentTitle;
    private static long mStartScoped;

    public static void test(Context context) {
        long start = System.currentTimeMillis();
        ValidatorTest.test();
        UtilsTest.test();
        JsonTest.test();
        MaterialUtilsTest.test();
        ModelTest.test();
        SerializationSpeedTest.test();
        EnvironmentTest.test();
        EventTest.test();
        SgnLocationTest.test();
        PageflipUtilsTest.test();
        ListUtilsTest.test();
        VersionTest.test();
        ReaderConfigTest.test();
        MaterialColorTest.test();
        PageflipTest.test();
        ExternalClientIdStoreTest.test(context);
        String ok = "*   All test passed (" + (System.currentTimeMillis() - start) + "ms)   *";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ok.length(); ++i) {
            sb.append("*");
        }
        String header = sb.toString();
        SgnLog.d(TAG, "Done: " + mCurrentTitle + " (" + (System.currentTimeMillis() - mStartScoped) + "ms)");
        SgnLog.d(TAG, header);
        SgnLog.d(TAG, ok);
        SgnLog.d(TAG, header);
        mCurrentTitle = null;
    }

    protected static void start(String testName) {
        if (mCurrentTitle == null) {
            mStartScoped = System.currentTimeMillis();
            SgnLog.d(TAG, "Performing: " + testName);
        } else if (!mCurrentTitle.equals(testName)) {
            SgnLog.d(TAG, "Done: " + mCurrentTitle + " (" + (System.currentTimeMillis() - mStartScoped) + "ms)");
            mStartScoped = System.currentTimeMillis();
            SgnLog.d(TAG, "Performing: " + testName);
        }
        mCurrentTitle = testName;
    }

    protected static void logTest(String tag, String testName) {
    }

    protected static void logTestWarning(String tag, String testName, String warning) {
        SgnLog.w(tag, " - " + testName + " - " + warning);
    }

    static {
        mStartScoped = 0L;
    }
}

