/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.HotspotMap;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import com.shopgun.android.sdk.test.MethodNameHelper;
import com.shopgun.android.sdk.test.ModelCreator;
import com.shopgun.android.sdk.test.SdkTest;
import java.util.List;
import junit.framework.Assert;

public class PageflipUtilsTest {
    public static final String TAG = Constants.getTag(PageflipUtilsTest.class);
    private static final boolean LANDSCAPE = true;
    private static final boolean PORTRAIT = false;

    private PageflipUtilsTest() {
    }

    public static void test() {
        SdkTest.start(TAG);
        PageflipUtilsTest.testJoin();
        PageflipUtilsTest.testCatalogUtils();
    }

    public static void testJoin() {
        Assert.assertEquals((String)"0,1,2", (String)PageflipUtils.join(",", new int[]{0, 1, 2}));
        Assert.assertEquals((String)"100,200,300", (String)PageflipUtils.join(",", new int[]{100, 200, 300}));
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    private static void testCatalogUtils() {
        Catalog c = ModelCreator.getCatalog();
        Assert.assertTrue((boolean)PageflipUtils.isHotspotsReady(c));
        Assert.assertTrue((boolean)PageflipUtils.isPagesReady(c));
        Assert.assertTrue((boolean)PageflipUtils.isCatalogReady(c));
        HotspotMap map = c.getHotspots();
        c.setHotspots(null);
        Assert.assertFalse((boolean)PageflipUtils.isHotspotsReady(c));
        Assert.assertFalse((boolean)PageflipUtils.isCatalogReady(c));
        List<Images> pages = c.getPages();
        c.setPages(null);
        Assert.assertFalse((boolean)PageflipUtils.isPagesReady(c));
        Assert.assertFalse((boolean)PageflipUtils.isCatalogReady(c));
        pages.clear();
        c.setPages(pages);
        Assert.assertFalse((boolean)PageflipUtils.isPagesReady(c));
        Assert.assertFalse((boolean)PageflipUtils.isCatalogReady(c));
        pages.add(ModelCreator.getImages(c.getId(), 0));
        pages.add(ModelCreator.getImages(c.getId(), 1));
        pages.add(ModelCreator.getImages(c.getId(), 2));
        c.setHotspots(map);
        Assert.assertTrue((boolean)PageflipUtils.isHotspotsReady(c));
        Assert.assertTrue((boolean)PageflipUtils.isPagesReady(c));
        Assert.assertTrue((boolean)PageflipUtils.isCatalogReady(c));
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }
}

