/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.graphics.Color;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.palette.MaterialColor;
import com.shopgun.android.sdk.palette.SgnColor;
import com.shopgun.android.sdk.palette.Shade;
import com.shopgun.android.sdk.utils.ColorUtils;
import java.util.HashMap;
import java.util.Map;

public class MaterialColorTestCreator {
    public static final String TAG = Constants.getTag(MaterialColorTestCreator.class);
    public static final Map<String, Integer> ALL = new HashMap<String, Integer>();
    public static final Map<String, Integer> CUSTOM = new HashMap<String, Integer>();
    public static final Map<String, Integer> BRANDS = new HashMap<String, Integer>();

    private MaterialColorTestCreator() {
    }

    public static Map<MaterialColor, MaterialTestColor> getTestMap() {
        HashMap<MaterialColor, MaterialTestColor> map = new HashMap<MaterialColor, MaterialTestColor>();
        MaterialColorTestCreator.addTests(map);
        return map;
    }

    public static void generateTests() {
        for (Map.Entry<String, Integer> e : ALL.entrySet()) {
            String name = e.getKey();
            name = name.trim().replace(" ", "").toLowerCase();
            SgnColor color = new SgnColor(e.getValue());
            MaterialColorTestCreator.materialColorTestGenerator("map", name, color);
        }
    }

    public static void materialColorTestGenerator(String mapName, String name, MaterialColor color) {
        StringBuilder sb = new StringBuilder();
        sb.append("// test ").append(name).append("\n");
        sb.append("MaterialTestColor ").append(name).append(" = new MaterialTestColor();").append("\n");
        sb.append(name).append(".value = ").append(MaterialColorTestCreator.toHex(color.getValue())).append("; ").append("\n");
        sb.append(name).append(".luminance = ").append(color.getLuminance()).append("; ").append("\n");
        sb.append(name).append(".primaryText = ").append(MaterialColorTestCreator.toHex(color.getPrimaryText())).append("; ").append("\n");
        sb.append(name).append(".secondaryText = ").append(MaterialColorTestCreator.toHex(color.getSecondaryText())).append("; ").append("\n");
        sb.append(name).append(".disabledText = ").append(MaterialColorTestCreator.toHex(color.getDisabledText())).append("; ").append("\n");
        for (Shade s : Shade.values()) {
            MaterialColorTestCreator.printShadesToMap(sb, name + ".shades", s, color);
        }
        String mapFormat = "%s.put(new SgnColor(%s), %s);";
        sb.append(String.format(mapFormat, mapName, MaterialColorTestCreator.toHex(color.getValue()), name));
        sb.append("\n");
        SgnLog.d(TAG, sb.toString());
    }

    private static String toHex(int color) {
        return ColorUtils.toARGBString(color).replace("#", "0x");
    }

    private static void printShadesToMap(StringBuilder sb, String mapName, Shade s, MaterialColor color) {
        MaterialColor shadeColor = color.getColor(s);
        float[] hsv = ColorUtils.toHSV(shadeColor.getValue());
        String format = "%s.put(%s.%s, new Float[]{ %.2ff, %.2ff, %.2ff});";
        sb.append(String.format(format, new Object[]{mapName, Shade.class.getSimpleName(), s, Float.valueOf(hsv[0]), Float.valueOf(hsv[1]), Float.valueOf(hsv[2])})).append("\n");
    }

    public static void addTests(Map<MaterialColor, MaterialTestColor> map) {
        MaterialTestColor F\u00f8tex = new MaterialTestColor();
        F\u00f8tex.value = -14667174;
        F\u00f8tex.luminance = 0.03326465713130804;
        F\u00f8tex.primaryText = -1;
        F\u00f8tex.secondaryText = -1291845633;
        F\u00f8tex.disabledText = 0x4CFFFFFF;
        F\u00f8tex.shades.put(Shade.Shade50, new Float[]{Float.valueOf(224.0f), Float.valueOf(0.06f), Float.valueOf(0.93f)});
        F\u00f8tex.shades.put(Shade.Shade100, new Float[]{Float.valueOf(221.54f), Float.valueOf(0.13f), Float.valueOf(0.81f)});
        F\u00f8tex.shades.put(Shade.Shade200, new Float[]{Float.valueOf(220.91f), Float.valueOf(0.25f), Float.valueOf(0.68f)});
        F\u00f8tex.shades.put(Shade.Shade300, new Float[]{Float.valueOf(221.11f), Float.valueOf(0.39f), Float.valueOf(0.55f)});
        F\u00f8tex.shades.put(Shade.Shade400, new Float[]{Float.valueOf(221.69f), Float.valueOf(0.51f), Float.valueOf(0.45f)});
        F\u00f8tex.shades.put(Shade.Shade500, new Float[]{Float.valueOf(221.38f), Float.valueOf(0.64f), Float.valueOf(0.35f)});
        F\u00f8tex.shades.put(Shade.Shade600, new Float[]{Float.valueOf(219.27f), Float.valueOf(0.68f), Float.valueOf(0.32f)});
        F\u00f8tex.shades.put(Shade.Shade700, new Float[]{Float.valueOf(218.75f), Float.valueOf(0.72f), Float.valueOf(0.26f)});
        F\u00f8tex.shades.put(Shade.Shade800, new Float[]{Float.valueOf(216.92f), Float.valueOf(0.75f), Float.valueOf(0.2f)});
        F\u00f8tex.shades.put(Shade.Shade900, new Float[]{Float.valueOf(215.17f), Float.valueOf(0.78f), Float.valueOf(0.15f)});
        map.put(new SgnColor(-14667174), F\u00f8tex);
        MaterialTestColor Humac = new MaterialTestColor();
        Humac.value = -1250068;
        Humac.luminance = 0.8387990117407399;
        Humac.primaryText = -587202560;
        Humac.secondaryText = -1996488704;
        Humac.disabledText = 0x60000000;
        Humac.shades.put(Shade.Shade50, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.99f)});
        Humac.shades.put(Shade.Shade100, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.98f)});
        Humac.shades.put(Shade.Shade200, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.96f)});
        Humac.shades.put(Shade.Shade300, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.95f)});
        Humac.shades.put(Shade.Shade400, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.94f)});
        Humac.shades.put(Shade.Shade500, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.93f)});
        Humac.shades.put(Shade.Shade600, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.84f)});
        Humac.shades.put(Shade.Shade700, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.69f)});
        Humac.shades.put(Shade.Shade800, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.54f)});
        Humac.shades.put(Shade.Shade900, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.38f)});
        map.put(new SgnColor(-1250068), Humac);
        MaterialTestColor S\u00f8streneGrene = new MaterialTestColor();
        S\u00f8streneGrene.value = -1;
        S\u00f8streneGrene.luminance = 1.0;
        S\u00f8streneGrene.primaryText = -587202560;
        S\u00f8streneGrene.secondaryText = -1996488704;
        S\u00f8streneGrene.disabledText = 0x60000000;
        S\u00f8streneGrene.shades.put(Shade.Shade50, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        S\u00f8streneGrene.shades.put(Shade.Shade100, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        S\u00f8streneGrene.shades.put(Shade.Shade200, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        S\u00f8streneGrene.shades.put(Shade.Shade300, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        S\u00f8streneGrene.shades.put(Shade.Shade400, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        S\u00f8streneGrene.shades.put(Shade.Shade500, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        S\u00f8streneGrene.shades.put(Shade.Shade600, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.9f)});
        S\u00f8streneGrene.shades.put(Shade.Shade700, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.75f)});
        S\u00f8streneGrene.shades.put(Shade.Shade800, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.58f)});
        S\u00f8streneGrene.shades.put(Shade.Shade900, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.41f)});
        map.put(new SgnColor(-1), S\u00f8streneGrene);
        MaterialTestColor Rema = new MaterialTestColor();
        Rema.value = -16562023;
        Rema.luminance = 0.06953996322950529;
        Rema.primaryText = -1;
        Rema.secondaryText = -1291845633;
        Rema.disabledText = 0x4CFFFFFF;
        Rema.shades.put(Shade.Shade50, new Float[]{Float.valueOf(212.31f), Float.valueOf(0.11f), Float.valueOf(0.95f)});
        Rema.shades.put(Shade.Shade100, new Float[]{Float.valueOf(212.61f), Float.valueOf(0.2f), Float.valueOf(0.88f)});
        Rema.shades.put(Shade.Shade200, new Float[]{Float.valueOf(212.2f), Float.valueOf(0.4f), Float.valueOf(0.8f)});
        Rema.shades.put(Shade.Shade300, new Float[]{Float.valueOf(212.48f), Float.valueOf(0.59f), Float.valueOf(0.72f)});
        Rema.shades.put(Shade.Shade400, new Float[]{Float.valueOf(212.03f), Float.valueOf(0.79f), Float.valueOf(0.66f)});
        Rema.shades.put(Shade.Shade500, new Float[]{Float.valueOf(212.4f), Float.valueOf(0.98f), Float.valueOf(0.6f)});
        Rema.shades.put(Shade.Shade600, new Float[]{Float.valueOf(210.88f), Float.valueOf(0.99f), Float.valueOf(0.54f)});
        Rema.shades.put(Shade.Shade700, new Float[]{Float.valueOf(209.73f), Float.valueOf(0.98f), Float.valueOf(0.45f)});
        Rema.shades.put(Shade.Shade800, new Float[]{Float.valueOf(207.95f), Float.valueOf(0.99f), Float.valueOf(0.35f)});
        Rema.shades.put(Shade.Shade900, new Float[]{Float.valueOf(207.54f), Float.valueOf(0.98f), Float.valueOf(0.24f)});
        map.put(new SgnColor(-16562023), Rema);
        MaterialTestColor Spar = new MaterialTestColor();
        Spar.value = -1237980;
        Spar.luminance = 0.18962407588560998;
        Spar.primaryText = -1;
        Spar.secondaryText = -1291845633;
        Spar.disabledText = 0x4CFFFFFF;
        Spar.shades.put(Shade.Shade50, new Float[]{Float.valueOf(357.5f), Float.valueOf(0.09f), Float.valueOf(0.99f)});
        Spar.shades.put(Shade.Shade100, new Float[]{Float.valueOf(357.39f), Float.valueOf(0.18f), Float.valueOf(0.98f)});
        Spar.shades.put(Shade.Shade200, new Float[]{Float.valueOf(357.27f), Float.valueOf(0.36f), Float.valueOf(0.96f)});
        Spar.shades.put(Shade.Shade300, new Float[]{Float.valueOf(357.23f), Float.valueOf(0.53f), Float.valueOf(0.95f)});
        Spar.shades.put(Shade.Shade400, new Float[]{Float.valueOf(357.53f), Float.valueOf(0.71f), Float.valueOf(0.94f)});
        Spar.shades.put(Shade.Shade500, new Float[]{Float.valueOf(357.7f), Float.valueOf(0.88f), Float.valueOf(0.93f)});
        Spar.shades.put(Shade.Shade600, new Float[]{Float.valueOf(356.27f), Float.valueOf(0.9f), Float.valueOf(0.84f)});
        Spar.shades.put(Shade.Shade700, new Float[]{Float.valueOf(355.21f), Float.valueOf(0.92f), Float.valueOf(0.7f)});
        Spar.shades.put(Shade.Shade800, new Float[]{Float.valueOf(354.33f), Float.valueOf(0.93f), Float.valueOf(0.54f)});
        Spar.shades.put(Shade.Shade900, new Float[]{Float.valueOf(352.83f), Float.valueOf(0.95f), Float.valueOf(0.38f)});
        map.put(new SgnColor(-1237980), Spar);
        MaterialTestColor Green = new MaterialTestColor();
        Green.value = -16711936;
        Green.luminance = 0.7152;
        Green.primaryText = -587202560;
        Green.secondaryText = -1996488704;
        Green.disabledText = 0x60000000;
        Green.shades.put(Shade.Shade50, new Float[]{Float.valueOf(120.0f), Float.valueOf(0.11f), Float.valueOf(1.0f)});
        Green.shades.put(Shade.Shade100, new Float[]{Float.valueOf(120.0f), Float.valueOf(0.21f), Float.valueOf(1.0f)});
        Green.shades.put(Shade.Shade200, new Float[]{Float.valueOf(120.0f), Float.valueOf(0.41f), Float.valueOf(1.0f)});
        Green.shades.put(Shade.Shade300, new Float[]{Float.valueOf(120.0f), Float.valueOf(0.6f), Float.valueOf(1.0f)});
        Green.shades.put(Shade.Shade400, new Float[]{Float.valueOf(120.0f), Float.valueOf(0.8f), Float.valueOf(1.0f)});
        Green.shades.put(Shade.Shade500, new Float[]{Float.valueOf(120.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
        Green.shades.put(Shade.Shade600, new Float[]{Float.valueOf(118.43f), Float.valueOf(1.0f), Float.valueOf(0.9f)});
        Green.shades.put(Shade.Shade700, new Float[]{Float.valueOf(117.17f), Float.valueOf(0.99f), Float.valueOf(0.75f)});
        Green.shades.put(Shade.Shade800, new Float[]{Float.valueOf(115.51f), Float.valueOf(0.99f), Float.valueOf(0.58f)});
        Green.shades.put(Shade.Shade900, new Float[]{Float.valueOf(114.17f), Float.valueOf(0.99f), Float.valueOf(0.41f)});
        map.put(new SgnColor(-16711936), Green);
        MaterialTestColor Flugger = new MaterialTestColor();
        Flugger.value = -12894464;
        Flugger.luminance = 0.04484820321188035;
        Flugger.primaryText = -1;
        Flugger.secondaryText = -1291845633;
        Flugger.disabledText = 0x4CFFFFFF;
        Flugger.shades.put(Shade.Shade50, new Float[]{Float.valueOf(62.31f), Float.valueOf(0.11f), Float.valueOf(0.91f)});
        Flugger.shades.put(Shade.Shade100, new Float[]{Float.valueOf(64.39f), Float.valueOf(0.21f), Float.valueOf(0.78f)});
        Flugger.shades.put(Shade.Shade200, new Float[]{Float.valueOf(63.69f), Float.valueOf(0.41f), Float.valueOf(0.62f)});
        Flugger.shades.put(Shade.Shade300, new Float[]{Float.valueOf(63.29f), Float.valueOf(0.6f), Float.valueOf(0.47f)});
        Flugger.shades.put(Shade.Shade400, new Float[]{Float.valueOf(64.05f), Float.valueOf(0.8f), Float.valueOf(0.36f)});
        Flugger.shades.put(Shade.Shade500, new Float[]{Float.valueOf(63.81f), Float.valueOf(1.0f), Float.valueOf(0.25f)});
        Flugger.shades.put(Shade.Shade600, new Float[]{Float.valueOf(62.14f), Float.valueOf(1.0f), Float.valueOf(0.22f)});
        Flugger.shades.put(Shade.Shade700, new Float[]{Float.valueOf(60.0f), Float.valueOf(1.0f), Float.valueOf(0.18f)});
        Flugger.shades.put(Shade.Shade800, new Float[]{Float.valueOf(60.0f), Float.valueOf(1.0f), Float.valueOf(0.14f)});
        Flugger.shades.put(Shade.Shade900, new Float[]{Float.valueOf(60.0f), Float.valueOf(1.0f), Float.valueOf(0.1f)});
        map.put(new SgnColor(-12894464), Flugger);
        MaterialTestColor Silvan = new MaterialTestColor();
        Silvan.value = -13414240;
        Silvan.luminance = 0.08979194254580962;
        Silvan.primaryText = -1;
        Silvan.secondaryText = -1291845633;
        Silvan.disabledText = 0x4CFFFFFF;
        Silvan.shades.put(Shade.Shade50, new Float[]{Float.valueOf(222.35f), Float.valueOf(0.07f), Float.valueOf(0.96f)});
        Silvan.shades.put(Shade.Shade100, new Float[]{Float.valueOf(222.58f), Float.valueOf(0.14f), Float.valueOf(0.89f)});
        Silvan.shades.put(Shade.Shade200, new Float[]{Float.valueOf(223.16f), Float.valueOf(0.27f), Float.valueOf(0.82f)});
        Silvan.shades.put(Shade.Shade300, new Float[]{Float.valueOf(224.42f), Float.valueOf(0.41f), Float.valueOf(0.74f)});
        Silvan.shades.put(Shade.Shade400, new Float[]{Float.valueOf(224.21f), Float.valueOf(0.55f), Float.valueOf(0.68f)});
        Silvan.shades.put(Shade.Shade500, new Float[]{Float.valueOf(224.04f), Float.valueOf(0.68f), Float.valueOf(0.63f)});
        Silvan.shades.put(Shade.Shade600, new Float[]{Float.valueOf(222.52f), Float.valueOf(0.72f), Float.valueOf(0.56f)});
        Silvan.shades.put(Shade.Shade700, new Float[]{Float.valueOf(221.12f), Float.valueOf(0.74f), Float.valueOf(0.47f)});
        Silvan.shades.put(Shade.Shade800, new Float[]{Float.valueOf(220.0f), Float.valueOf(0.77f), Float.valueOf(0.36f)});
        Silvan.shades.put(Shade.Shade900, new Float[]{Float.valueOf(218.49f), Float.valueOf(0.82f), Float.valueOf(0.25f)});
        map.put(new SgnColor(-13414240), Silvan);
        MaterialTestColor Netto = new MaterialTestColor();
        Netto.value = -8448;
        Netto.luminance = 0.740353524354257;
        Netto.primaryText = -587202560;
        Netto.secondaryText = -1996488704;
        Netto.disabledText = 0x60000000;
        Netto.shades.put(Shade.Shade50, new Float[]{Float.valueOf(53.57f), Float.valueOf(0.11f), Float.valueOf(1.0f)});
        Netto.shades.put(Shade.Shade100, new Float[]{Float.valueOf(53.21f), Float.valueOf(0.21f), Float.valueOf(1.0f)});
        Netto.shades.put(Shade.Shade200, new Float[]{Float.valueOf(52.5f), Float.valueOf(0.41f), Float.valueOf(1.0f)});
        Netto.shades.put(Shade.Shade300, new Float[]{Float.valueOf(52.6f), Float.valueOf(0.6f), Float.valueOf(1.0f)});
        Netto.shades.put(Shade.Shade400, new Float[]{Float.valueOf(52.68f), Float.valueOf(0.8f), Float.valueOf(1.0f)});
        Netto.shades.put(Shade.Shade500, new Float[]{Float.valueOf(52.47f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
        Netto.shades.put(Shade.Shade600, new Float[]{Float.valueOf(51.13f), Float.valueOf(1.0f), Float.valueOf(0.9f)});
        Netto.shades.put(Shade.Shade700, new Float[]{Float.valueOf(49.63f), Float.valueOf(0.99f), Float.valueOf(0.75f)});
        Netto.shades.put(Shade.Shade800, new Float[]{Float.valueOf(48.16f), Float.valueOf(0.99f), Float.valueOf(0.58f)});
        Netto.shades.put(Shade.Shade900, new Float[]{Float.valueOf(47.18f), Float.valueOf(0.99f), Float.valueOf(0.41f)});
        map.put(new SgnColor(-8448), Netto);
        MaterialTestColor Blue = new MaterialTestColor();
        Blue.value = -16776961;
        Blue.luminance = 0.0722;
        Blue.primaryText = -1;
        Blue.secondaryText = -1291845633;
        Blue.disabledText = 0x4CFFFFFF;
        Blue.shades.put(Shade.Shade50, new Float[]{Float.valueOf(240.0f), Float.valueOf(0.11f), Float.valueOf(1.0f)});
        Blue.shades.put(Shade.Shade100, new Float[]{Float.valueOf(240.0f), Float.valueOf(0.21f), Float.valueOf(1.0f)});
        Blue.shades.put(Shade.Shade200, new Float[]{Float.valueOf(240.0f), Float.valueOf(0.41f), Float.valueOf(1.0f)});
        Blue.shades.put(Shade.Shade300, new Float[]{Float.valueOf(240.0f), Float.valueOf(0.6f), Float.valueOf(1.0f)});
        Blue.shades.put(Shade.Shade400, new Float[]{Float.valueOf(240.0f), Float.valueOf(0.8f), Float.valueOf(1.0f)});
        Blue.shades.put(Shade.Shade500, new Float[]{Float.valueOf(240.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
        Blue.shades.put(Shade.Shade600, new Float[]{Float.valueOf(238.43f), Float.valueOf(1.0f), Float.valueOf(0.9f)});
        Blue.shades.put(Shade.Shade700, new Float[]{Float.valueOf(237.49f), Float.valueOf(0.99f), Float.valueOf(0.75f)});
        Blue.shades.put(Shade.Shade800, new Float[]{Float.valueOf(235.92f), Float.valueOf(0.99f), Float.valueOf(0.58f)});
        Blue.shades.put(Shade.Shade900, new Float[]{Float.valueOf(234.76f), Float.valueOf(0.99f), Float.valueOf(0.41f)});
        map.put(new SgnColor(-16776961), Blue);
        MaterialTestColor Red = new MaterialTestColor();
        Red.value = -65536;
        Red.luminance = 0.2126;
        Red.primaryText = -1;
        Red.secondaryText = -1291845633;
        Red.disabledText = 0x4CFFFFFF;
        Red.shades.put(Shade.Shade50, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.11f), Float.valueOf(1.0f)});
        Red.shades.put(Shade.Shade100, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.21f), Float.valueOf(1.0f)});
        Red.shades.put(Shade.Shade200, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.41f), Float.valueOf(1.0f)});
        Red.shades.put(Shade.Shade300, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.6f), Float.valueOf(1.0f)});
        Red.shades.put(Shade.Shade400, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.8f), Float.valueOf(1.0f)});
        Red.shades.put(Shade.Shade500, new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)});
        Red.shades.put(Shade.Shade600, new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.9f)});
        Red.shades.put(Shade.Shade700, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.99f), Float.valueOf(0.75f)});
        Red.shades.put(Shade.Shade800, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.99f), Float.valueOf(0.58f)});
        Red.shades.put(Shade.Shade900, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.99f), Float.valueOf(0.41f)});
        map.put(new SgnColor(-65536), Red);
        MaterialTestColor SuperBrugsen = new MaterialTestColor();
        SuperBrugsen.value = -1033923;
        SuperBrugsen.luminance = 0.21788441760296845;
        SuperBrugsen.primaryText = -1;
        SuperBrugsen.secondaryText = -1291845633;
        SuperBrugsen.disabledText = 0x4CFFFFFF;
        SuperBrugsen.shades.put(Shade.Shade50, new Float[]{Float.valueOf(357.0f), Float.valueOf(0.08f), Float.valueOf(1.0f)});
        SuperBrugsen.shades.put(Shade.Shade100, new Float[]{Float.valueOf(358.46f), Float.valueOf(0.16f), Float.valueOf(0.98f)});
        SuperBrugsen.shades.put(Shade.Shade200, new Float[]{Float.valueOf(358.42f), Float.valueOf(0.31f), Float.valueOf(0.97f)});
        SuperBrugsen.shades.put(Shade.Shade300, new Float[]{Float.valueOf(358.41f), Float.valueOf(0.46f), Float.valueOf(0.96f)});
        SuperBrugsen.shades.put(Shade.Shade400, new Float[]{Float.valueOf(358.39f), Float.valueOf(0.61f), Float.valueOf(0.95f)});
        SuperBrugsen.shades.put(Shade.Shade500, new Float[]{Float.valueOf(358.69f), Float.valueOf(0.76f), Float.valueOf(0.94f)});
        SuperBrugsen.shades.put(Shade.Shade600, new Float[]{Float.valueOf(357.19f), Float.valueOf(0.79f), Float.valueOf(0.85f)});
        SuperBrugsen.shades.put(Shade.Shade700, new Float[]{Float.valueOf(356.33f), Float.valueOf(0.82f), Float.valueOf(0.71f)});
        SuperBrugsen.shades.put(Shade.Shade800, new Float[]{Float.valueOf(354.92f), Float.valueOf(0.85f), Float.valueOf(0.55f)});
        SuperBrugsen.shades.put(Shade.Shade900, new Float[]{Float.valueOf(353.72f), Float.valueOf(0.88f), Float.valueOf(0.38f)});
        map.put(new SgnColor(-1033923), SuperBrugsen);
        MaterialTestColor Meny = new MaterialTestColor();
        Meny.value = -3339983;
        Meny.luminance = 0.13396261147898136;
        Meny.primaryText = -1;
        Meny.secondaryText = -1291845633;
        Meny.disabledText = 0x4CFFFFFF;
        Meny.shades.put(Shade.Shade50, new Float[]{Float.valueOf(346.15f), Float.valueOf(0.1f), Float.valueOf(0.98f)});
        Meny.shades.put(Shade.Shade100, new Float[]{Float.valueOf(347.5f), Float.valueOf(0.2f), Float.valueOf(0.94f)});
        Meny.shades.put(Shade.Shade200, new Float[]{Float.valueOf(347.33f), Float.valueOf(0.39f), Float.valueOf(0.9f)});
        Meny.shades.put(Shade.Shade300, new Float[]{Float.valueOf(347.72f), Float.valueOf(0.58f), Float.valueOf(0.86f)});
        Meny.shades.put(Shade.Shade400, new Float[]{Float.valueOf(347.56f), Float.valueOf(0.77f), Float.valueOf(0.84f)});
        Meny.shades.put(Shade.Shade500, new Float[]{Float.valueOf(347.76f), Float.valueOf(0.96f), Float.valueOf(0.8f)});
        Meny.shades.put(Shade.Shade600, new Float[]{Float.valueOf(346.52f), Float.valueOf(0.96f), Float.valueOf(0.73f)});
        Meny.shades.put(Shade.Shade700, new Float[]{Float.valueOf(345.5f), Float.valueOf(0.97f), Float.valueOf(0.6f)});
        Meny.shades.put(Shade.Shade800, new Float[]{Float.valueOf(343.97f), Float.valueOf(0.97f), Float.valueOf(0.47f)});
        Meny.shades.put(Shade.Shade900, new Float[]{Float.valueOf(343.17f), Float.valueOf(0.98f), Float.valueOf(0.33f)});
        map.put(new SgnColor(-3339983), Meny);
        MaterialTestColor Black = new MaterialTestColor();
        Black.value = -16777216;
        Black.luminance = 0.0;
        Black.primaryText = -1;
        Black.secondaryText = -1291845633;
        Black.disabledText = 0x4CFFFFFF;
        Black.shades.put(Shade.Shade50, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.88f)});
        Black.shades.put(Shade.Shade100, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.7f)});
        Black.shades.put(Shade.Shade200, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.5f)});
        Black.shades.put(Shade.Shade300, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.3f)});
        Black.shades.put(Shade.Shade400, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.15f)});
        Black.shades.put(Shade.Shade500, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        Black.shades.put(Shade.Shade600, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        Black.shades.put(Shade.Shade700, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        Black.shades.put(Shade.Shade800, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        Black.shades.put(Shade.Shade900, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
        map.put(new SgnColor(-16777216), Black);
        MaterialTestColor eTilbudsavis = new MaterialTestColor();
        eTilbudsavis.value = -8679143;
        eTilbudsavis.luminance = 0.24531938838449666;
        eTilbudsavis.primaryText = -1;
        eTilbudsavis.secondaryText = -1291845633;
        eTilbudsavis.disabledText = 0x4CFFFFFF;
        eTilbudsavis.shades.put(Shade.Shade50, new Float[]{Float.valueOf(71.43f), Float.valueOf(0.09f), Float.valueOf(0.95f)});
        eTilbudsavis.shades.put(Shade.Shade100, new Float[]{Float.valueOf(69.47f), Float.valueOf(0.17f), Float.valueOf(0.87f)});
        eTilbudsavis.shades.put(Shade.Shade200, new Float[]{Float.valueOf(70.75f), Float.valueOf(0.34f), Float.valueOf(0.78f)});
        eTilbudsavis.shades.put(Shade.Shade300, new Float[]{Float.valueOf(70.79f), Float.valueOf(0.5f), Float.valueOf(0.7f)});
        eTilbudsavis.shades.put(Shade.Shade400, new Float[]{Float.valueOf(70.56f), Float.valueOf(0.67f), Float.valueOf(0.64f)});
        eTilbudsavis.shades.put(Shade.Shade500, new Float[]{Float.valueOf(71.0f), Float.valueOf(0.83f), Float.valueOf(0.57f)});
        eTilbudsavis.shades.put(Shade.Shade600, new Float[]{Float.valueOf(69.64f), Float.valueOf(0.85f), Float.valueOf(0.51f)});
        eTilbudsavis.shades.put(Shade.Shade700, new Float[]{Float.valueOf(68.21f), Float.valueOf(0.87f), Float.valueOf(0.43f)});
        eTilbudsavis.shades.put(Shade.Shade800, new Float[]{Float.valueOf(66.4f), Float.valueOf(0.89f), Float.valueOf(0.33f)});
        eTilbudsavis.shades.put(Shade.Shade900, new Float[]{Float.valueOf(65.56f), Float.valueOf(0.92f), Float.valueOf(0.23f)});
        map.put(new SgnColor(-8679143), eTilbudsavis);
        MaterialTestColor ShopGun2 = new MaterialTestColor();
        ShopGun2.value = -1171847;
        ShopGun2.luminance = 0.2048616547122194;
        ShopGun2.primaryText = -1;
        ShopGun2.secondaryText = -1291845633;
        ShopGun2.disabledText = 0x4CFFFFFF;
        ShopGun2.shades.put(Shade.Shade50, new Float[]{Float.valueOf(332.5f), Float.valueOf(0.09f), Float.valueOf(0.99f)});
        ShopGun2.shades.put(Shade.Shade100, new Float[]{Float.valueOf(332.61f), Float.valueOf(0.18f), Float.valueOf(0.98f)});
        ShopGun2.shades.put(Shade.Shade200, new Float[]{Float.valueOf(333.41f), Float.valueOf(0.36f), Float.valueOf(0.97f)});
        ShopGun2.shades.put(Shade.Shade300, new Float[]{Float.valueOf(333.49f), Float.valueOf(0.53f), Float.valueOf(0.96f)});
        ShopGun2.shades.put(Shade.Shade400, new Float[]{Float.valueOf(333.53f), Float.valueOf(0.71f), Float.valueOf(0.95f)});
        ShopGun2.shades.put(Shade.Shade500, new Float[]{Float.valueOf(333.75f), Float.valueOf(0.87f), Float.valueOf(0.93f)});
        ShopGun2.shades.put(Shade.Shade600, new Float[]{Float.valueOf(332.5f), Float.valueOf(0.89f), Float.valueOf(0.84f)});
        ShopGun2.shades.put(Shade.Shade700, new Float[]{Float.valueOf(331.29f), Float.valueOf(0.91f), Float.valueOf(0.7f)});
        ShopGun2.shades.put(Shade.Shade800, new Float[]{Float.valueOf(330.0f), Float.valueOf(0.93f), Float.valueOf(0.54f)});
        ShopGun2.shades.put(Shade.Shade900, new Float[]{Float.valueOf(329.01f), Float.valueOf(0.94f), Float.valueOf(0.38f)});
        map.put(new SgnColor(-1171847), ShopGun2);
        MaterialTestColor White = new MaterialTestColor();
        White.value = -1;
        White.luminance = 1.0;
        White.primaryText = -587202560;
        White.secondaryText = -1996488704;
        White.disabledText = 0x60000000;
        White.shades.put(Shade.Shade50, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        White.shades.put(Shade.Shade100, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        White.shades.put(Shade.Shade200, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        White.shades.put(Shade.Shade300, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        White.shades.put(Shade.Shade400, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        White.shades.put(Shade.Shade500, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f)});
        White.shades.put(Shade.Shade600, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.9f)});
        White.shades.put(Shade.Shade700, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.75f)});
        White.shades.put(Shade.Shade800, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.58f)});
        White.shades.put(Shade.Shade900, new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.41f)});
        map.put(new SgnColor(-1), White);
    }

    static {
        CUSTOM.put("ShopGun", Color.parseColor((String)"#ee1e79"));
        CUSTOM.put("eTilbudsavis", Color.parseColor((String)"#7b9119"));
        CUSTOM.put("eTilbudsavis-new", Color.parseColor((String)"#01c545"));
        CUSTOM.put("Black", Color.parseColor((String)"#000000"));
        CUSTOM.put("White", Color.parseColor((String)"#FFFFFF"));
        CUSTOM.put("Red", Color.parseColor((String)"#FF0000"));
        CUSTOM.put("Green", Color.parseColor((String)"#00FF00"));
        CUSTOM.put("Blue", Color.parseColor((String)"#0000FF"));
        BRANDS.put("Netto", Color.parseColor((String)"#ffdf00"));
        BRANDS.put("F\u00f8tex", Color.parseColor((String)"#20325A"));
        BRANDS.put("Humac", Color.parseColor((String)"#ECECEC"));
        BRANDS.put("Super Brugsen", Color.parseColor((String)"#f0393d"));
        BRANDS.put("S\u00f8strene Grene", Color.parseColor((String)"#FFFFFF"));
        BRANDS.put("Spar", Color.parseColor((String)"#ed1c24"));
        BRANDS.put("Silvan", Color.parseColor((String)"#3350a0"));
        BRANDS.put("Rema", Color.parseColor((String)"#034899"));
        BRANDS.put("Meny", Color.parseColor((String)"#CD0931"));
        BRANDS.put("Flugger", Color.parseColor((String)"#3b3f00"));
        ALL.putAll(CUSTOM);
        ALL.putAll(BRANDS);
    }

    protected static class MaterialTestColor {
        float threshold = 0.01f;
        int value = -16777216;
        double luminance = 0.0;
        int primaryText = -1;
        int secondaryText = -1291845633;
        int disabledText = 0x4CFFFFFF;
        Map<Shade, Float[]> shades = new HashMap<Shade, Float[]>();

        protected MaterialTestColor() {
        }
    }
}

