/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.palette.MaterialColor;
import com.shopgun.android.sdk.palette.Shade;
import com.shopgun.android.sdk.test.MaterialColorTestCreator;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.ColorUtils;
import java.util.Map;
import junit.framework.TestCase;

public class MaterialColorTest
extends TestCase {
    public static final String TAG = Constants.getTag(MaterialColorTest.class);

    private MaterialColorTest() {
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public static void test() {
        SgnLog.v(TAG, "MaterialColorTest isn't working");
        Map<MaterialColor, MaterialColorTestCreator.MaterialTestColor> map = MaterialColorTestCreator.getTestMap();
        for (Map.Entry<MaterialColor, MaterialColorTestCreator.MaterialTestColor> e : map.entrySet()) {
            MaterialColor c = e.getKey();
            MaterialColorTestCreator.MaterialTestColor v = e.getValue();
            MaterialColorTest.testMaterialColor(c, v);
        }
        SdkTest.start(TAG);
    }

    public static void testMaterialColor(MaterialColor c, MaterialColorTestCreator.MaterialTestColor v) {
        MaterialColorTest.assertEquals((int)c.getValue(), (int)v.value);
        MaterialColorTest.assertEquals((double)c.getLuminance(), (double)v.luminance, (double)1.0E-5);
        MaterialColorTest.assertEquals((int)c.getPrimaryText(), (int)v.primaryText);
        MaterialColorTest.assertEquals((int)c.getSecondaryText(), (int)v.secondaryText);
        MaterialColorTest.assertEquals((int)c.getDisabledText(), (int)v.disabledText);
        for (Shade s : Shade.values()) {
            MaterialColorTest.testShade(s, c, v.shades.get((Object)s));
        }
    }

    public static void testShade(Shade s, MaterialColor c, Float[] expectedHSV) {
        int color = c.getColor(s).getValue();
        float[] hsv = ColorUtils.toHSV(color);
        float delta = 0.01f;
        for (int i = 0; i < 2; ++i) {
            MaterialColorTest.assertEquals((float)expectedHSV[i].floatValue(), (float)hsv[i], (float)delta);
        }
    }
}

