/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.test.ModelCreator;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.ListUtils;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Assert;

public class ListUtilsTest {
    public static final String TAG = Constants.getTag(ListUtilsTest.class);

    public static void test() {
        SdkTest.start(TAG);
        ListUtilsTest.testGetShoppinglistIdsFromItems();
        ListUtilsTest.testGetShoppinglistIdsFromLists();
    }

    public static void testGetShoppinglistIdsFromItems() {
        ArrayList<ShoppinglistItem> items = new ArrayList<ShoppinglistItem>();
        int count = 10;
        int modulo = 10;
        for (int i = 0; i < count; ++i) {
            int id2 = i % modulo;
            ShoppinglistItem sli = ModelCreator.getShoppinglistItem("item-id-" + id2, "description-" + id2);
            sli.setShoppinglistId("list-id-" + id2);
            items.add(sli);
        }
        HashSet<String> listIds = ListUtils.getShoppinglistIdsFromItems(items);
        Assert.assertEquals((int)modulo, (int)listIds.size());
        items = new ArrayList();
        count = 10;
        modulo = 10;
        for (int i = 0; i < count; ++i) {
            int id3 = i % modulo;
            ShoppinglistItem sli = ModelCreator.getShoppinglistItem("item-id-" + id3, "description-" + id3);
            sli.setShoppinglistId("list-id-" + id3);
            items.add(sli);
        }
        listIds = ListUtils.getShoppinglistIdsFromItems(items);
        Assert.assertEquals((int)modulo, (int)listIds.size());
        SdkTest.logTest(TAG, "GetShoppinglistIdsFromItems");
    }

    public static void testGetShoppinglistIdsFromLists() {
        ArrayList<Shoppinglist> lists = new ArrayList<Shoppinglist>();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            Shoppinglist sl = ModelCreator.getShoppinglist("id" + i, "name-" + i);
            lists.add(sl);
        }
        HashSet<String> listIds = ListUtils.getShoppinglistIdsFromLists(lists);
        Assert.assertEquals((int)lists.size(), (int)listIds.size());
        SdkTest.logTest(TAG, "GetShoppinglistIdsFromLists");
    }
}

