/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.content.Context;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.ExternalClientIdStore;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.model.Session;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.Utils;
import junit.framework.TestCase;

public class ExternalClientIdStoreTest
extends TestCase {
    public static final String TAG = Constants.getTag(ExternalClientIdStoreTest.class);

    public static void test(Context ctx) {
        SdkTest.start(TAG);
        ShopGun sgn = ShopGun.getInstance(ctx);
        String current = sgn.getSettings().getClientId();
        ExternalClientIdStore.clear(sgn);
        Session s = new Session();
        ExternalClientIdStore.updateCid(s, sgn);
        ExternalClientIdStoreTest.assertNull((Object)s.getClientId());
        ExternalClientIdStoreTest.assertNull((Object)sgn.getSettings().getClientId());
        String first = "fake_client_id";
        s.setClientId(first);
        ExternalClientIdStore.updateCid(s, sgn);
        ExternalClientIdStoreTest.assertEquals((String)first, (String)s.getClientId());
        ExternalClientIdStoreTest.assertEquals((String)first, (String)sgn.getSettings().getClientId());
        String second = Utils.createUUID();
        s.setClientId(second);
        ExternalClientIdStore.updateCid(s, sgn);
        ExternalClientIdStoreTest.assertEquals((String)second, (String)s.getClientId());
        ExternalClientIdStoreTest.assertEquals((String)second, (String)sgn.getSettings().getClientId());
        s = new Session();
        ExternalClientIdStore.updateCid(s, sgn);
        ExternalClientIdStoreTest.assertEquals((String)second, (String)s.getClientId());
        ExternalClientIdStore.clear(sgn);
        String junk = "randomjunkid";
        s = new Session();
        s.setClientId(junk);
        ExternalClientIdStore.updateCid(s, sgn);
        ExternalClientIdStoreTest.assertNotSame((Object)junk, (Object)s.getClientId());
        sgn.getSettings().setClientId(current);
    }
}

