/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.bus.SessionEvent;
import com.shopgun.android.sdk.bus.ShoppinglistEvent;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.test.MethodNameHelper;
import com.shopgun.android.sdk.test.SdkTest;
import java.util.List;
import junit.framework.Assert;

public class EventTest {
    public static final String TAG = Constants.getTag(EventTest.class);

    private EventTest() {
    }

    public static void test() {
        SdkTest.start(TAG);
        EventTest.testShoppinglistEvent();
        EventTest.testSessionEvent();
    }

    public static void testShoppinglistEvent() {
        ShoppinglistEvent.Builder b = new ShoppinglistEvent.Builder(true);
        Assert.assertTrue((boolean)b.isServer);
        Assert.assertFalse((boolean)b.hasChanges());
        Assert.assertFalse((boolean)b.firstSync);
        b.firstSync = true;
        Assert.assertTrue((boolean)b.hasChanges());
        b.firstSync = false;
        Shoppinglist added = Shoppinglist.fromName("added");
        added.setType("wish_list");
        b.add(added);
        Shoppinglist edited = Shoppinglist.fromName("edited");
        edited.setType("wish_list");
        b.edit(edited);
        Shoppinglist deleted = Shoppinglist.fromName("deleted");
        deleted.setType("wish_list");
        b.del(deleted);
        Assert.assertTrue((boolean)b.hasChanges());
        List<Shoppinglist> list = b.getLists();
        Assert.assertEquals((int)3, (int)list.size());
        Assert.assertEquals((int)list.size(), (int)b.lists.size());
        List<Shoppinglist> listAdded = b.getAddedLists();
        Assert.assertEquals((int)1, (int)listAdded.size());
        Shoppinglist addedEdited = listAdded.get(0);
        addedEdited.setType("shopping_list");
        Assert.assertEquals((Object)added, (Object)addedEdited);
        for (int i = 0; i < 10; ++i) {
            b.add(new ShoppinglistItem(added, "item-" + i));
        }
        String id2 = "myspeciallistid";
        Shoppinglist specialSlId = Shoppinglist.fromName(id2);
        specialSlId.setId(id2);
        b.add(new ShoppinglistItem(specialSlId, id2));
        ShoppinglistEvent e = b.build();
        Assert.assertEquals((int)e.getItems().size(), (int)b.getItems().size());
        Assert.assertEquals((int)e.getAddedItems().size(), (int)b.getAddedItems().size());
        Assert.assertEquals((boolean)e.isServer(), (boolean)b.isServer);
        Assert.assertEquals((boolean)e.isFirstSync(), (boolean)b.firstSync);
        Assert.assertEquals((int)e.getLists().size(), (int)b.getLists().size());
        Assert.assertEquals((int)1, (int)e.getAddedItems(id2).size());
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    public static void testSessionEvent() {
        int oldUser = 0;
        int newUser = 100;
        SessionEvent e = new SessionEvent(oldUser, newUser);
        Assert.assertEquals((int)oldUser, (int)e.getOldUser());
        Assert.assertEquals((int)newUser, (int)e.getNewUser());
        Assert.assertTrue((boolean)e.isNewUser());
        oldUser = 1;
        newUser = 1;
        e = new SessionEvent(oldUser, newUser);
        Assert.assertEquals((int)oldUser, (int)e.getOldUser());
        Assert.assertEquals((int)newUser, (int)e.getNewUser());
        Assert.assertFalse((boolean)e.isNewUser());
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }
}

