/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.content.res.Configuration;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.pageflip.Orientation;
import com.shopgun.android.sdk.pageflip.ReaderConfig;
import com.shopgun.android.sdk.pageflip.impl.DoublePageReaderConfig;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import com.shopgun.android.sdk.test.MethodNameHelper;
import com.shopgun.android.sdk.test.SdkTest;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DoublePageReaderConfigTest
extends TestCase {
    public static final String TAG = DoublePageReaderConfigTest.class.getSimpleName();

    public static void test() {
        SdkTest.start(TAG);
        DoublePageReaderConfig two = new DoublePageReaderConfig();
        two.setConfiguration(new Configuration());
        DoublePageReaderConfigTest.testIsLandscape(two);
        DoublePageReaderConfigTest.testPositionToPage(two);
        DoublePageReaderConfigTest.testPageToPosition(two);
    }

    public static void testIsLandscape(ReaderConfig r) {
        r.setConfiguration(null);
        DoublePageReaderConfigTest.assertEquals((Object)((Object)Orientation.PORTRAIT), (Object)((Object)r.getOrientation()));
        Configuration c = new Configuration();
        c.orientation = 2;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.assertTrue((boolean)r.isLandscape());
        c.orientation = 1;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        c.orientation = 0;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        c.orientation = 3;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.assertFalse((boolean)r.isLandscape());
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    public static void testPageToPosition(ReaderConfig r) {
        Configuration c = new Configuration();
        r.setHasIntro(false);
        r.setHasOutro(false);
        c.orientation = 2;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 0);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 5, 2);
        c.orientation = 1;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 0);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 3);
        r.setHasIntro(true);
        r.setHasOutro(false);
        c.orientation = 2;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 3);
        DoublePageReaderConfigTest.testPageToPosition(r, 5, 3);
        c.orientation = 1;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 3);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 4);
        r.setHasIntro(false);
        r.setHasOutro(true);
        c.orientation = 2;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 0);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 5, 2);
        c.orientation = 1;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 0);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 3);
        r.setHasIntro(true);
        r.setHasOutro(true);
        c.orientation = 2;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 3);
        DoublePageReaderConfigTest.testPageToPosition(r, 5, 3);
        c.orientation = 1;
        r.setConfiguration(c);
        DoublePageReaderConfigTest.testPageToPosition(r, 1, 1);
        DoublePageReaderConfigTest.testPageToPosition(r, 2, 2);
        DoublePageReaderConfigTest.testPageToPosition(r, 3, 3);
        DoublePageReaderConfigTest.testPageToPosition(r, 4, 4);
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    private static void testPageToPosition(ReaderConfig config, int page, int expectedPos) {
        Assert.assertEquals((int)expectedPos, (int)config.pageToPosition(page));
    }

    public static void testPositionToPage(ReaderConfig r) {
        int PAGE_COUNT_LANDSCAPE = 8;
        ArrayList<ConfigTestCase> landscape = new ArrayList<ConfigTestCase>();
        int PAGE_COUNT_PORTRAIT = 4;
        ArrayList<ConfigTestCase> portrait = new ArrayList<ConfigTestCase>();
        Configuration c = new Configuration();
        r.setHasIntro(false);
        r.setHasOutro(false);
        landscape.clear();
        landscape.add(new ConfigTestCase(0, PAGE_COUNT_LANDSCAPE, new int[]{1}));
        landscape.add(new ConfigTestCase(1, PAGE_COUNT_LANDSCAPE, new int[]{2, 3}));
        landscape.add(new ConfigTestCase(2, PAGE_COUNT_LANDSCAPE, new int[]{4, 5}));
        landscape.add(new ConfigTestCase(3, PAGE_COUNT_LANDSCAPE, new int[]{6, 7}));
        landscape.add(new ConfigTestCase(4, PAGE_COUNT_LANDSCAPE, new int[]{8}));
        portrait.clear();
        portrait.add(new ConfigTestCase(0, PAGE_COUNT_PORTRAIT, new int[]{1}));
        portrait.add(new ConfigTestCase(1, PAGE_COUNT_PORTRAIT, new int[]{2}));
        portrait.add(new ConfigTestCase(2, PAGE_COUNT_PORTRAIT, new int[]{3}));
        portrait.add(new ConfigTestCase(3, PAGE_COUNT_PORTRAIT, new int[]{4}));
        portrait.add(new ConfigTestCase(4, PAGE_COUNT_PORTRAIT, new int[]{5}));
        c.orientation = 2;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : landscape) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        c.orientation = 1;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : portrait) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        r.setHasIntro(true);
        r.setHasOutro(false);
        landscape.clear();
        landscape.add(new ConfigTestCase(0, PAGE_COUNT_LANDSCAPE, new int[0]));
        landscape.add(new ConfigTestCase(1, PAGE_COUNT_LANDSCAPE, new int[]{1}));
        landscape.add(new ConfigTestCase(2, PAGE_COUNT_LANDSCAPE, new int[]{2, 3}));
        landscape.add(new ConfigTestCase(3, PAGE_COUNT_LANDSCAPE, new int[]{4, 5}));
        landscape.add(new ConfigTestCase(4, PAGE_COUNT_LANDSCAPE, new int[]{6, 7}));
        landscape.add(new ConfigTestCase(5, PAGE_COUNT_LANDSCAPE, new int[]{8}));
        portrait.clear();
        portrait.add(new ConfigTestCase(0, PAGE_COUNT_PORTRAIT, new int[0]));
        portrait.add(new ConfigTestCase(1, PAGE_COUNT_PORTRAIT, new int[]{1}));
        portrait.add(new ConfigTestCase(2, PAGE_COUNT_PORTRAIT, new int[]{2}));
        portrait.add(new ConfigTestCase(3, PAGE_COUNT_PORTRAIT, new int[]{3}));
        portrait.add(new ConfigTestCase(4, PAGE_COUNT_PORTRAIT, new int[]{4}));
        portrait.add(new ConfigTestCase(5, PAGE_COUNT_PORTRAIT, new int[]{5}));
        c.orientation = 2;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : landscape) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        c.orientation = 1;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : portrait) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        r.setHasIntro(false);
        r.setHasOutro(true);
        landscape.clear();
        landscape.add(new ConfigTestCase(0, PAGE_COUNT_LANDSCAPE, new int[]{1}));
        landscape.add(new ConfigTestCase(1, PAGE_COUNT_LANDSCAPE, new int[]{2, 3}));
        landscape.add(new ConfigTestCase(2, PAGE_COUNT_LANDSCAPE, new int[]{4, 5}));
        landscape.add(new ConfigTestCase(3, PAGE_COUNT_LANDSCAPE, new int[]{6, 7}));
        landscape.add(new ConfigTestCase(4, PAGE_COUNT_LANDSCAPE, new int[]{8}));
        landscape.add(new ConfigTestCase(5, PAGE_COUNT_LANDSCAPE, new int[0]));
        portrait.clear();
        portrait.add(new ConfigTestCase(0, PAGE_COUNT_PORTRAIT, new int[]{1}));
        portrait.add(new ConfigTestCase(1, PAGE_COUNT_PORTRAIT, new int[]{2}));
        portrait.add(new ConfigTestCase(2, PAGE_COUNT_PORTRAIT, new int[]{3}));
        portrait.add(new ConfigTestCase(3, PAGE_COUNT_PORTRAIT, new int[]{4}));
        portrait.add(new ConfigTestCase(4, PAGE_COUNT_PORTRAIT, new int[0]));
        c.orientation = 2;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : landscape) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        c.orientation = 1;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : portrait) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        r.setHasIntro(true);
        r.setHasOutro(true);
        landscape.clear();
        landscape.add(new ConfigTestCase(0, PAGE_COUNT_LANDSCAPE, new int[0]));
        landscape.add(new ConfigTestCase(1, PAGE_COUNT_LANDSCAPE, new int[]{1}));
        landscape.add(new ConfigTestCase(2, PAGE_COUNT_LANDSCAPE, new int[]{2, 3}));
        landscape.add(new ConfigTestCase(3, PAGE_COUNT_LANDSCAPE, new int[]{4, 5}));
        landscape.add(new ConfigTestCase(4, PAGE_COUNT_LANDSCAPE, new int[]{6, 7}));
        landscape.add(new ConfigTestCase(5, PAGE_COUNT_LANDSCAPE, new int[]{8}));
        landscape.add(new ConfigTestCase(6, PAGE_COUNT_LANDSCAPE, new int[0]));
        portrait.clear();
        portrait.add(new ConfigTestCase(0, PAGE_COUNT_PORTRAIT, new int[0]));
        portrait.add(new ConfigTestCase(1, PAGE_COUNT_PORTRAIT, new int[]{1}));
        portrait.add(new ConfigTestCase(2, PAGE_COUNT_PORTRAIT, new int[]{2}));
        portrait.add(new ConfigTestCase(3, PAGE_COUNT_PORTRAIT, new int[]{3}));
        portrait.add(new ConfigTestCase(4, PAGE_COUNT_PORTRAIT, new int[]{4}));
        portrait.add(new ConfigTestCase(5, PAGE_COUNT_PORTRAIT, new int[0]));
        c.orientation = 2;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : landscape) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        c.orientation = 1;
        r.setConfiguration(c);
        for (ConfigTestCase testCase : portrait) {
            DoublePageReaderConfigTest.testPositionToPage(r, testCase);
        }
        SdkTest.logTest(TAG, new MethodNameHelper(){}.getName());
    }

    private static void testPositionToPage(ReaderConfig config, ConfigTestCase testCase) {
        int[] pages = config.positionToPages(testCase.pos, testCase.pageCount);
        boolean eq = Arrays.equals(pages, testCase.expectedPages);
        if (!eq) {
            SgnLog.d(TAG, "ReaderConfig:    " + config.toString());
            SgnLog.d(TAG, "ConfigTestCase:  " + testCase.toString());
            SgnLog.d(TAG, "positionToPages: " + PageflipUtils.join(",", pages));
        }
        Assert.assertTrue((boolean)eq);
    }

    private static class ConfigTestCase {
        int pos;
        int pageCount;
        int[] expectedPages;

        public ConfigTestCase(int pos, int pageCount, int[] expectedPages) {
            this.pos = pos;
            this.pageCount = pageCount;
            this.expectedPages = expectedPages;
        }

        public String toString() {
            return String.format("%s[pos:%s, pageCount:%s, expectedPages:%s]", ConfigTestCase.class.getSimpleName(), this.pos, this.pageCount, PageflipUtils.join(",", this.expectedPages));
        }
    }
}

