/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.ModelListLoaderRequest;
import com.shopgun.android.sdk.requests.ModelListRequest;
import com.shopgun.android.sdk.requests.impl.StoreListLoaderRequest;
import java.util.List;
import org.json.JSONArray;

public class StoreListRequest
extends ModelListRequest<List<Store>> {
    public static final String TAG = Constants.getTag(StoreListRequest.class);

    public StoreListRequest(LoaderRequest.Listener<List<Store>> listener) {
        this(new StoreListLoaderRequest(listener), listener);
    }

    public StoreListRequest(ModelListLoaderRequest<List<Store>> loaderRequest, LoaderRequest.Listener<List<Store>> listener) {
        this("/v2/stores", loaderRequest, listener);
    }

    public StoreListRequest(String url, LoaderRequest.Listener<List<Store>> listener) {
        this(url, new StoreListLoaderRequest(listener), listener);
    }

    public StoreListRequest(String url, ModelListLoaderRequest<List<Store>> loaderRequest, LoaderRequest.Listener<List<Store>> listener) {
        super(url, loaderRequest, listener);
    }

    @Override
    public List<Store> parse(JSONArray response) {
        return Store.fromJSON(response);
    }

    @Override
    public boolean loadDealer() {
        return super.loadDealer();
    }

    public StoreListRequest loadDealer(boolean dealer) {
        super.loadDealer(dealer);
        return this;
    }

    @Override
    public boolean loadStore() {
        return super.loadStore();
    }

    public StoreListRequest loadStore(boolean store) {
        super.loadStore(store);
        return this;
    }

    @Override
    public boolean loadCatalog() {
        return super.loadCatalog();
    }

    public StoreListRequest loadCatalog(boolean catalog) {
        super.loadCatalog(catalog);
        return this;
    }
}

