/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.requests.InternalOkError;
import com.shopgun.android.sdk.requests.LoaderDelivery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LoaderRequest<T>
extends Request<T>
implements Delivery {
    public static final String TAG = Constants.getTag(LoaderRequest.class);
    private T mData;
    private final Listener<T> mListener;
    private final List<Request> mRequests = Collections.synchronizedList(new ArrayList());
    private final List<ShopGunError> mErrors = Collections.synchronizedList(new ArrayList());
    private final LoaderDelivery<T> mDelivery;
    private AtomicInteger mAtomicCounter = new AtomicInteger();

    public LoaderRequest(Listener<T> l) {
        this(null, l);
    }

    public LoaderRequest(T data, Listener<T> l) {
        super(Request.Method.PUT, null, null);
        this.mData = data;
        this.mListener = l;
        this.mDelivery = new LoaderDelivery<T>(this.mListener);
    }

    public synchronized T getData() {
        return this.mData;
    }

    public synchronized Request setData(T data) {
        this.mData = data;
        return this;
    }

    public Request addError(ShopGunError e) {
        this.mErrors.add(e);
        return this;
    }

    public List<ShopGunError> getErrors() {
        return this.mErrors;
    }

    @Override
    public synchronized Request setRequestQueue(RequestQueue requestQueue) {
        if (this.getTag() == null) {
            this.setTag(new Object());
        }
        super.setDelivery(this);
        super.setRequestQueue(requestQueue);
        this.mRequests.addAll(this.createRequests(this.mData));
        Iterator<Request> it = this.mRequests.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        this.mAtomicCounter.set(this.mRequests.size());
        if (this.mAtomicCounter.get() == 0) {
            this.finish("loaderRequest-has-no-subRequests-to-perform");
        } else {
            this.addEvent("sub-requests-added-to-request-queue");
            for (Request r : this.mRequests) {
                r.addEvent("added-from-loader-request");
                this.applyState(r);
                this.getRequestQueue().add(r);
            }
        }
        this.addEvent("cancelled-to-force-cache-dispatcher-to-drop-loader-request");
        super.cancel();
        return this;
    }

    @Override
    public Request setDelivery(Delivery d) {
        throw new IllegalStateException("Custom delivery not allowed for LoaderRequests");
    }

    @Override
    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        return Response.fromError(new InternalOkError());
    }

    @Override
    protected Response<T> parseCache(Cache c) {
        return Response.fromError(new InternalOkError());
    }

    public abstract List<Request> createRequests(T var1);

    private void applyState(Request r) {
        r.setDebugger(this.getDebugger());
        r.setDelivery(this);
        r.setTag(this.getTag());
        r.setIgnoreCache(this.ignoreCache());
        r.setTimeOut(this.getTimeOut());
        r.setUseLocation(this.useLocation());
    }

    @Override
    public synchronized void cancel() {
        super.cancel();
        for (Request request : this.mRequests) {
            if (request.isCanceled()) continue;
            request.cancel();
        }
    }

    @Override
    public synchronized Request finish(String reason) {
        if (super.isFinished()) {
            return this;
        }
        return super.finish(reason);
    }

    @Override
    public synchronized boolean isFinished() {
        for (Request r : this.mRequests) {
            if (r.isFinished()) continue;
            return false;
        }
        return super.isFinished();
    }

    @Override
    public synchronized void postResponse(Request<?> request, Response<?> response) {
        request.addEvent("post-response");
        boolean intermediate = this.mAtomicCounter.decrementAndGet() > 0;
        this.mDelivery.deliver(request, response, this.mData, this.mErrors, intermediate);
    }

    public static interface Listener<T> {
        public void onRequestComplete(T var1, List<ShopGunError> var2);

        public void onRequestIntermediate(T var1, List<ShopGunError> var2);
    }
}

