/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.photoview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.photoview.Compat;
import com.shopgun.android.sdk.photoview.gestures.GestureDetector;
import com.shopgun.android.sdk.photoview.gestures.OnGestureListener;
import com.shopgun.android.sdk.photoview.gestures.VersionedGestureDetector;
import com.shopgun.android.sdk.photoview.scrollerproxy.ScrollerProxy;

public class PhotoView
extends ImageView
implements View.OnTouchListener,
OnGestureListener,
ViewTreeObserver.OnGlobalLayoutListener {
    public static final String TAG = Constants.getTag(PhotoView.class);
    public static final float DEFAULT_MAX_SCALE = 3.0f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    public static final int DEFAULT_ZOOM_DURATION = 200;
    static final Interpolator sInterpolator = new AccelerateDecelerateInterpolator();
    static final int EDGE_NONE = -1;
    static final int EDGE_LEFT = 0;
    static final int EDGE_RIGHT = 1;
    static final int EDGE_BOTH = 2;
    private static final boolean DEBUG = false;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private final float[] mMatrixValues = new float[9];
    private int mZoomDuration = 200;
    private float mMinScale = 1.0f;
    private float mMaxScale = 3.0f;
    private boolean mAllowParentInterceptOnEdge = true;
    private GestureDetector mScaleDragDetector;
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private OnViewTapListener mViewTapListener;
    private OnPhotoLongClickListener mPhotoLongClickListener;
    private OnViewLongClickListener mViewLongClickListener;
    private OnPhotoDoubleClickListener mPhotoDoubleClickListener;
    private OnViewDoubleClickListener mViewDoubleClickListener;
    private int mIvTop;
    private int mIvRight;
    private int mIvBottom;
    private int mIvLeft;
    private FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge = 2;
    private boolean mZoomEnabled = true;
    private boolean mAnimating = false;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;

    public PhotoView(Context context) {
        super(context);
        this.init();
    }

    public PhotoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PhotoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public static boolean hasDrawable(ImageView imageView) {
        return null != imageView && null != imageView.getDrawable();
    }

    private void init() {
        this.setDrawingCacheEnabled(true);
        this.setOnTouchListener(this);
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (null != observer) {
            observer.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.setImageViewScaleTypeMatrix();
        if (this.isInEditMode()) {
            return;
        }
        this.mScaleDragDetector = VersionedGestureDetector.newInstance(this.getContext(), this);
        this.setZoomable(true);
    }

    public boolean canZoom() {
        return this.mZoomEnabled;
    }

    public RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDrawMatrix());
    }

    public boolean setDisplayMatrix(Matrix finalMatrix) {
        if (finalMatrix == null) {
            throw new IllegalArgumentException("Matrix cannot be null");
        }
        if (null == this.getDrawable()) {
            return false;
        }
        this.mSuppMatrix.set(finalMatrix);
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
        return true;
    }

    public Matrix getDisplayMatrix() {
        return new Matrix(this.getDrawMatrix());
    }

    public float getMinimumScale() {
        return this.mMinScale;
    }

    public void setMinimumScale(float minimumScale) {
        this.checkZoomLevels(minimumScale, this.mMaxScale);
        this.mMinScale = minimumScale;
    }

    public float getMaximumScale() {
        return this.mMaxScale;
    }

    public void setMaximumScale(float maximumScale) {
        this.checkZoomLevels(this.mMinScale, maximumScale);
        this.mMaxScale = maximumScale;
    }

    public float getScale() {
        return (float)Math.sqrt(Math.pow(this.getValue(this.mSuppMatrix, 0), 2.0) + Math.pow(this.getValue(this.mSuppMatrix, 3), 2.0));
    }

    public void setScale(float scale) {
        this.setScale(scale, false);
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (this.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAllowParentInterceptOnEdge = allow;
    }

    public boolean isAnimating() {
        return this.mAnimating;
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener listener) {
        this.mMatrixChangeListener = listener;
    }

    public OnPhotoTapListener getOnPhotoTapListener() {
        return this.mPhotoTapListener;
    }

    public void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.mPhotoTapListener = listener;
    }

    public OnViewTapListener getOnViewTapListener() {
        return this.mViewTapListener;
    }

    public void setOnViewTapListener(OnViewTapListener listener) {
        this.mViewTapListener = listener;
    }

    public OnPhotoLongClickListener getOnPhotoLongClickListener() {
        return this.mPhotoLongClickListener;
    }

    public void setOnPhotoLongClickListener(OnPhotoLongClickListener listener) {
        this.mPhotoLongClickListener = listener;
    }

    public OnViewLongClickListener getOnViewLongClickListener() {
        return this.mViewLongClickListener;
    }

    public void setOnViewLongClickListener(OnViewLongClickListener listener) {
        this.mViewLongClickListener = listener;
    }

    public OnPhotoDoubleClickListener getOnPhotoDoubleClickListener() {
        return this.mPhotoDoubleClickListener;
    }

    public void setOnPhotoDoubleClickListener(OnPhotoDoubleClickListener listener) {
        this.mPhotoDoubleClickListener = listener;
    }

    public OnViewDoubleClickListener getOnViewDoubleClickListener() {
        return this.mViewDoubleClickListener;
    }

    public void setOnViewDoubleClickListener(OnViewDoubleClickListener listener) {
        this.mViewDoubleClickListener = listener;
    }

    public void setRotationTo(float rotationDegree) {
        this.mSuppMatrix.setRotate(rotationDegree % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public void setRotationBy(float rotationDegree) {
        this.mSuppMatrix.postRotate(rotationDegree % 360.0f);
        this.checkAndDisplayMatrix();
    }

    public void setScale(float scale, boolean animate) {
        this.setScale(scale, this.getRight() / 2, this.getBottom() / 2, animate);
    }

    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        if (scale < this.mMinScale || scale > this.mMaxScale) {
            SgnLog.i(TAG, "Scale must be within the range of minScale and maxScale");
            return;
        }
        if (animate) {
            this.post(new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
        } else {
            this.mSuppMatrix.setScale(scale, scale, focalX, focalY);
            this.checkAndDisplayMatrix();
        }
    }

    public void setZoomable(boolean zoomable) {
        this.mZoomEnabled = zoomable;
        this.update();
    }

    public Bitmap getVisibleRectangleBitmap() {
        return this.getDrawingCache();
    }

    public void setZoomTransitionDuration(int milliseconds) {
        this.mZoomDuration = milliseconds < 0 ? 200 : milliseconds;
    }

    public void setOnGestureListener(OnGestureListener.SimpleOnGestureListener gestureListener) {
        if (gestureListener != null) {
            this.mScaleDragDetector.setOnGestureListener(gestureListener);
        }
    }

    private void cleanup() {
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (null != observer && observer.isAlive()) {
            observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.setOnTouchListener(null);
        this.cancelFling();
        if (this.mScaleDragDetector != null) {
            this.mScaleDragDetector.setOnGestureListener(null);
        }
        this.mMatrixChangeListener = null;
        this.mPhotoTapListener = null;
        this.mViewTapListener = null;
        this.mPhotoLongClickListener = null;
        this.mViewLongClickListener = null;
        this.mPhotoDoubleClickListener = null;
        this.mViewDoubleClickListener = null;
    }

    private void update() {
        if (this.mZoomEnabled) {
            this.setImageViewScaleTypeMatrix();
            this.updateBaseMatrix(this.getDrawable());
        } else {
            this.resetMatrix();
        }
    }

    public Matrix getDrawMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    protected Matrix getSupportMatrix() {
        return this.mSuppMatrix;
    }

    private void cancelFling() {
        if (null != this.mCurrentFlingRunnable) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setImageViewMatrix(this.getDrawMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        RectF displayRect;
        this.setImageMatrix(matrix);
        if (null != this.mMatrixChangeListener && null != (displayRect = this.getDisplayRect(matrix))) {
            this.mMatrixChangeListener.onMatrixChanged(displayRect);
        }
    }

    private void updateBaseMatrix(Drawable d) {
        if (d == null) {
            return;
        }
        float viewWidth = this.getImageViewWidth();
        float viewHeight = this.getImageViewHeight();
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.mScaleType == ImageView.ScaleType.CENTER) {
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_CROP) {
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float scale = Math.min(1.0f, Math.min(widthScale, heightScale));
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else {
            RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
            RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
            switch (this.mScaleType) {
                case FIT_CENTER: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                    break;
                }
            }
        }
        this.resetMatrix();
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            this.setImageViewMatrix(this.getDrawMatrix());
        }
    }

    private boolean checkMatrixBounds() {
        RectF rect = this.getDisplayRect(this.getDrawMatrix());
        if (null == rect) {
            return false;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = this.getImageViewHeight();
        if (height <= (float)viewHeight) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaY = -rect.top;
                    break;
                }
                case FIT_END: {
                    deltaY = (float)viewHeight - height - rect.top;
                    break;
                }
                default: {
                    deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
                    break;
                }
            }
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
        }
        int viewWidth = this.getImageViewWidth();
        if (width <= (float)viewWidth) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaX = -rect.left;
                    break;
                }
                case FIT_END: {
                    deltaX = (float)viewWidth - width - rect.left;
                    break;
                }
                default: {
                    deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
                }
            }
            this.mScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.mScrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(deltaX, deltaY);
        return true;
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable d = this.getDrawable();
        if (null != d) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private void checkZoomLevels(float minZoom, float maxZoom) {
        if (minZoom >= maxZoom) {
            throw new IllegalArgumentException("minZoom has to be less than MaxZoom");
        }
    }

    private boolean isSupportedScaleType(ImageView.ScaleType scaleType) {
        if (null == scaleType) {
            return false;
        }
        switch (scaleType) {
            case MATRIX: {
                throw new IllegalArgumentException(scaleType.name() + " is not supported in PhotoView");
            }
        }
        return true;
    }

    private int getImageViewWidth() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private int getImageViewHeight() {
        return this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    private void setImageViewScaleTypeMatrix() {
        if (!ImageView.ScaleType.MATRIX.equals((Object)this.getScaleType())) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    protected void onDetachedFromWindow() {
        this.cleanup();
        super.onDetachedFromWindow();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.update();
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.update();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.update();
    }

    public void onGlobalLayout() {
        if (this.mZoomEnabled) {
            int top = this.getTop();
            int right = this.getRight();
            int bottom = this.getBottom();
            int left = this.getLeft();
            if (top != this.mIvTop || bottom != this.mIvBottom || left != this.mIvLeft || right != this.mIvRight) {
                this.updateBaseMatrix(this.getDrawable());
                this.mIvTop = top;
                this.mIvRight = right;
                this.mIvBottom = bottom;
                this.mIvLeft = left;
            }
        } else {
            this.updateBaseMatrix(this.getDrawable());
        }
    }

    @Override
    public void onDrag(float dx, float dy) {
        if (this.mScaleDragDetector.isScaling()) {
            return;
        }
        this.log(TAG, String.format("onDrag: dx: %.2f. dy: %.2f", Float.valueOf(dx), Float.valueOf(dy)));
        this.mSuppMatrix.postTranslate(dx, dy);
        this.checkAndDisplayMatrix();
        ViewParent parent = this.getParent();
        if (this.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling()) {
            if ((this.mScrollEdge == 2 || this.mScrollEdge == 0 && dx >= 1.0f || this.mScrollEdge == 1 && dx <= -1.0f) && null != parent) {
                parent.requestDisallowInterceptTouchEvent(false);
            }
        } else if (null != parent) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    @Override
    public void onFling(float startX, float startY, float velocityX, float velocityY) {
        this.log(TAG, "onFling. sX: " + startX + " sY: " + startY + " Vx: " + velocityX + " Vy: " + velocityY);
        this.mCurrentFlingRunnable = new FlingRunnable(this.getContext());
        this.mCurrentFlingRunnable.fling(this.getImageViewWidth(), this.getImageViewHeight(), (int)velocityX, (int)velocityY);
        this.post(this.mCurrentFlingRunnable);
    }

    @Override
    public void onScale(float scaleFactor, float focusX, float focusY) {
        this.log(TAG, String.format("onScale: scale: %.2f. fX: %.2f. fY: %.2f", Float.valueOf(scaleFactor), Float.valueOf(focusX), Float.valueOf(focusY)));
        if (this.getScale() < this.mMaxScale || scaleFactor < 1.0f) {
            this.mSuppMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
            this.checkAndDisplayMatrix();
        }
    }

    @Override
    public boolean onSingleTab(MotionEvent e) {
        PointF p;
        boolean handled = false;
        if (null != this.mPhotoTapListener && (p = this.eventToPhotoCoordinate(e)) != null) {
            this.mPhotoTapListener.onPhotoTap((View)this, p.x, p.y);
            handled = true;
        }
        if (null != this.mViewTapListener) {
            this.mViewTapListener.onViewTap((View)this, e.getX(), e.getY());
            handled = true;
        }
        return handled;
    }

    @Override
    public boolean onDoubleTab(MotionEvent e) {
        PointF p;
        boolean handled = false;
        try {
            float scale = this.getScale();
            float min = this.getMinimumScale();
            float max = this.getMaximumScale();
            float x = e.getX();
            float y = e.getY();
            float midScale = min + (max - min) / 2.0f;
            if (scale < midScale) {
                this.setScale(max, x, y, true);
            } else {
                this.setScale(min, x, y, true);
            }
            handled = true;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        if (this.mPhotoDoubleClickListener != null && (p = this.eventToPhotoCoordinate(e)) != null) {
            this.mPhotoDoubleClickListener.onPhotoDoubleTap((View)this, p.x, p.y);
        }
        if (null != this.mViewDoubleClickListener) {
            this.mViewDoubleClickListener.onViewDoubleTap((View)this, e.getX(), e.getY());
        }
        return handled;
    }

    @Override
    public boolean onLongPress(MotionEvent e) {
        PointF p;
        if (this.mPhotoLongClickListener != null && (p = this.eventToPhotoCoordinate(e)) != null) {
            this.mPhotoLongClickListener.onPhotoLongTap((View)this, p.x, p.y);
        }
        if (null != this.mViewLongClickListener) {
            this.mViewLongClickListener.onViewLongTap((View)this, e.getX(), e.getY());
        }
        return false;
    }

    private PointF eventToPhotoCoordinate(MotionEvent e) {
        PointF p = null;
        try {
            float y;
            RectF displayRect = this.getDisplayRect();
            if (null == displayRect) {
                return p;
            }
            float x = e.getX();
            if (displayRect.contains(x, y = e.getY())) {
                p = new PointF();
                p.x = (x - displayRect.left) / displayRect.width();
                p.y = (y - displayRect.top) / displayRect.height();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return p;
    }

    public boolean onTouch(View v, MotionEvent event) {
        boolean handled = false;
        if (this.mZoomEnabled && PhotoView.hasDrawable((ImageView)v)) {
            ViewParent parent = v.getParent();
            switch (event.getAction()) {
                case 0: {
                    if (null != parent) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    } else {
                        SgnLog.i(TAG, "onTouch getParent() returned null");
                    }
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    if (!(this.getScale() < this.mMinScale) || null == (rect = this.getDisplayRect())) break;
                    v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rect.centerX(), rect.centerY()));
                    handled = true;
                }
            }
            if (null != this.mScaleDragDetector && this.mScaleDragDetector.onTouchEvent(event)) {
                handled = true;
            }
        }
        return handled;
    }

    private void log(String tag, String msg) {
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerProxy mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = ScrollerProxy.getScroller(context);
        }

        public void cancelFling() {
            PhotoView.this.log(TAG, "Cancel Fling");
            this.mScroller.forceFinished(true);
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = PhotoView.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            PhotoView.this.log(TAG, "fling. StartX:" + startX + " StartY:" + startY + " MaxX:" + maxX + " MaxY:" + maxY);
            if (startX != maxX || startY != maxY) {
                PhotoView.this.mAnimating = true;
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            PhotoView.this.mAnimating = !this.mScroller.isFinished() && this.mScroller.computeScrollOffset();
            if (PhotoView.this.mAnimating) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                PhotoView.this.log(TAG, "fling run(). CurrentX:" + this.mCurrentX + " CurrentY:" + this.mCurrentY + " NewX:" + newX + " NewY:" + newY);
                PhotoView.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                PhotoView.this.setImageViewMatrix(PhotoView.this.getDrawMatrix());
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                Compat.postOnAnimation((View)PhotoView.this, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mStartTime = System.currentTimeMillis();
            this.mZoomStart = currentZoom;
            this.mZoomEnd = targetZoom;
        }

        @Override
        public void run() {
            float t = this.interpolate();
            float scale = this.mZoomStart + t * (this.mZoomEnd - this.mZoomStart);
            float deltaScale = scale / PhotoView.this.getScale();
            PhotoView.this.mAnimating = t < 1.0f;
            PhotoView.this.mSuppMatrix.postScale(deltaScale, deltaScale, this.mFocalX, this.mFocalY);
            PhotoView.this.checkAndDisplayMatrix();
            if (PhotoView.this.mAnimating) {
                Compat.postOnAnimation((View)PhotoView.this, this);
            }
        }

        private float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)PhotoView.this.mZoomDuration;
            t = Math.min(1.0f, t);
            t = sInterpolator.getInterpolation(t);
            return t;
        }
    }

    public static interface OnViewDoubleClickListener {
        public void onViewDoubleTap(View var1, float var2, float var3);
    }

    public static interface OnPhotoDoubleClickListener {
        public void onPhotoDoubleTap(View var1, float var2, float var3);
    }

    public static interface OnViewLongClickListener {
        public void onViewLongTap(View var1, float var2, float var3);
    }

    public static interface OnPhotoLongClickListener {
        public void onPhotoLongTap(View var1, float var2, float var3);
    }

    public static interface OnViewTapListener {
        public void onViewTap(View var1, float var2, float var3);
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap(View var1, float var2, float var3);
    }

    public static interface OnMatrixChangedListener {
        public void onMatrixChanged(RectF var1);
    }
}

