/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.palette;

import android.graphics.Color;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.palette.MaterialColor;
import com.shopgun.android.sdk.palette.Shade;
import com.shopgun.android.utils.ColorUtils;

public class SgnColor
implements MaterialColor {
    public static final String TAG = SgnColor.class.getSimpleName();
    public static final int TEXT_ALPHA_DISABLED_LIGHT = 76;
    public static final int TEXT_ALPHA_DISABLED_DARK = 96;
    public static final int TEXT_ALPHA_SECONDARY_LIGHT = 178;
    public static final int TEXT_ALPHA_SECONDARY_DARK = 137;
    public static final int TEXT_ALPHA_PRIMARY_LIGHT = 255;
    public static final int TEXT_ALPHA_PRIMARY_DARK = 221;
    public static final double THRESHOLD_VERY_BRIGHT = 0.95;
    public static final double THRESHOLD_BRIGHT = 0.87;
    public static final double THRESHOLD_LIGHT = 0.54;
    public static final double THRESHOLD_DARK = 0.13;
    public static final double THRESHOLD_VERY_DARK = 0.025;
    private static float[] mValuePercentConversion = new float[]{1.06f, 0.7f, 0.5f, 0.3f, 0.15f, 0.0f, -0.1f, -0.25f, -0.42f, -0.59f};
    private final int mColor;
    public static final Parcelable.Creator<SgnColor> CREATOR = new Parcelable.Creator<SgnColor>(){

        public SgnColor createFromParcel(Parcel source) {
            return new SgnColor(source);
        }

        public SgnColor[] newArray(int size) {
            return new SgnColor[size];
        }
    };

    public SgnColor() {
        this(-16777216);
    }

    public SgnColor(int color) {
        this.mColor = color;
    }

    public SgnColor(MaterialColor color) {
        this.mColor = color.getValue();
    }

    public static float getModifiedHue(float hue, Shade shade) {
        float s = shade.getValue();
        if (s > 500.0f) {
            float hueAt900 = 1.003f * (hue /= 360.0f) - 0.016f;
            hue = (hueAt900 - hue) / 400.0f * (s - 500.0f) + hue;
            return hue * 360.0f;
        }
        return hue;
    }

    public static float getModifiedSaturation(float saturation, Shade shade) {
        if (shade.getValue() == 500) {
            return saturation;
        }
        if (shade.getValue() < 500) {
            float f = 0.136f * saturation - 0.025f;
            float satAt50 = Math.max(f, 0.0f);
            return (saturation - satAt50) / 450.0f * (float)(shade.getValue() - 50) + satAt50;
        }
        float satAt900 = Math.min(-1.019f * saturation * saturation + 2.283f * saturation - 0.281f, 1.0f);
        return (satAt900 - saturation) / 400.0f * (float)(shade.getValue() - 500) + saturation;
    }

    public static float getModifiedValue(float value, Shade shade) {
        float valuePercent;
        if (shade.getValue() == 500) {
            return value;
        }
        float indexFloat = (float)shade.getValue() / 100.0f;
        int indexFloor = (int)Math.floor(indexFloat);
        int indexCeil = (int)Math.ceil(indexFloat);
        int max = mValuePercentConversion.length - 1;
        int lowerIndex = Math.min(Math.max(indexFloor, 0), max);
        int upperIndex = Math.min(Math.max(indexCeil, 0), max);
        float lowerPercent = mValuePercentConversion[lowerIndex];
        if (lowerIndex != upperIndex) {
            float upperPercent = mValuePercentConversion[upperIndex];
            float deltaPercent = upperPercent - lowerPercent;
            float deltaIndex = upperIndex - lowerIndex;
            valuePercent = lowerPercent + deltaPercent / deltaIndex * (indexFloat - (float)lowerIndex);
        } else {
            valuePercent = lowerPercent;
        }
        if (shade.getValue() < 500) {
            return value + (1.0f - value) * valuePercent;
        }
        return value + value * valuePercent;
    }

    public static MaterialColor getModifiedColor(int color, Shade shade) {
        int modified = color;
        if (shade != Shade.Shade500) {
            float[] hsv = new float[3];
            Color.colorToHSV((int)color, (float[])hsv);
            hsv[0] = SgnColor.getModifiedHue(hsv[0], shade);
            hsv[1] = SgnColor.getModifiedSaturation(hsv[1], shade);
            hsv[2] = SgnColor.getModifiedValue(hsv[2], shade);
            modified = Color.HSVToColor((int)Color.alpha((int)color), (float[])hsv);
        }
        return new SgnColor(modified);
    }

    @Override
    public MaterialColor getColor(Shade s) {
        return SgnColor.getModifiedColor(this.mColor, s);
    }

    @Override
    public int getValue() {
        return this.mColor;
    }

    @Override
    public int getPrimaryText() {
        return SgnColor.getPrimaryTextColor(this.isLight());
    }

    public static int getPrimaryTextColor(boolean brightBackground) {
        int color = brightBackground ? -16777216 : -1;
        int alpha = brightBackground ? 221 : 255;
        return ColorUtils.setAlphaComponent((int)color, (int)alpha);
    }

    @Override
    public int getSecondaryText() {
        return SgnColor.getSecondaryTextColor(this.isLight());
    }

    public static int getSecondaryTextColor(boolean brightBackground) {
        int color = brightBackground ? -16777216 : -1;
        int alpha = brightBackground ? 137 : 178;
        return ColorUtils.setAlphaComponent((int)color, (int)alpha);
    }

    @Override
    public int getDisabledText() {
        return SgnColor.getDisabledTextColor(this.isLight());
    }

    public static int getDisabledTextColor(boolean brightBackground) {
        int color = brightBackground ? -16777216 : -1;
        int alpha = brightBackground ? 96 : 76;
        return ColorUtils.setAlphaComponent((int)color, (int)alpha);
    }

    @Override
    public double getLuminance() {
        return ColorUtils.calculateLuminance((int)this.mColor);
    }

    @Override
    public boolean isVeryBright() {
        return this.getLuminance() > 0.95;
    }

    @Override
    public boolean isBright() {
        return this.getLuminance() > 0.87;
    }

    @Override
    public boolean isLight() {
        return this.getLuminance() > 0.54;
    }

    @Override
    public boolean isDark() {
        return this.getLuminance() < 0.13;
    }

    @Override
    public boolean isVeryDark() {
        return this.getLuminance() < 0.025;
    }

    public String toString() {
        return ColorUtils.toARGBString((int)this.mColor);
    }

    public boolean isDarker(int other) {
        return this.getLuminance() < ColorUtils.calculateLuminance((int)other);
    }

    public boolean isLighter(int other) {
        return this.getLuminance() > ColorUtils.calculateLuminance((int)other);
    }

    public String toHSVString() {
        return ColorUtils.toHsvString((int)this.mColor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SgnColor sgnColor = (SgnColor)o;
        return this.mColor == sgnColor.mColor;
    }

    public int hashCode() {
        return this.mColor;
    }

    public boolean equals(SgnColor o, int tolerance) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.mColor == o.mColor) {
            return true;
        }
        if (tolerance == 0) {
            return false;
        }
        int r1 = Color.red((int)this.mColor);
        int g1 = Color.green((int)this.mColor);
        int b1 = Color.blue((int)this.mColor);
        int a1 = Color.alpha((int)this.mColor);
        int r2 = Color.red((int)o.mColor);
        int g2 = Color.green((int)o.mColor);
        int b2 = Color.blue((int)o.mColor);
        int a2 = Color.alpha((int)o.mColor);
        return Math.abs(r1 - r2) <= tolerance && Math.abs(g1 - g2) <= tolerance && Math.abs(b1 - b2) <= tolerance && Math.abs(a1 - a2) <= tolerance;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mColor);
    }

    protected SgnColor(Parcel in) {
        this.mColor = in.readInt();
    }
}

