/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.palette;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.palette.MaterialColor;
import com.shopgun.android.sdk.palette.SgnColor;
import com.shopgun.android.utils.ColorUtils;

public class MaterialUtils {
    public static final String TAG = Constants.getTag(MaterialUtils.class);

    private MaterialUtils() {
    }

    public static String toARGBString(MaterialColor color) {
        return color == null ? null : ColorUtils.toARGBString((int)color.getValue());
    }

    public static String toHsvString(MaterialColor color) {
        return ColorUtils.toHsvString((float[])ColorUtils.toHSV((int)color.getValue()));
    }

    public static double calculateLuminance(MaterialColor color) {
        return ColorUtils.calculateLuminance((int)color.getValue());
    }

    public static MaterialColor setAlphaComponent(MaterialColor color, int alpha) {
        return new SgnColor(ColorUtils.setAlphaComponent((int)color.getValue(), (int)alpha));
    }

    public static double calculateContrast(MaterialColor foreground, MaterialColor background) {
        return ColorUtils.calculateContrast((int)foreground.getValue(), (int)background.getValue());
    }

    public static int calculateMinimumAlpha(MaterialColor foreground, MaterialColor background, float minContrastRatio) {
        return ColorUtils.calculateMinimumAlpha((int)foreground.getValue(), (int)background.getValue(), (float)minContrastRatio);
    }
}

