/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import com.shopgun.android.sdk.photoview.PhotoView;

public class ZoomPhotoView
extends PhotoView
implements PhotoView.OnMatrixChangedListener {
    public static final String TAG = Constants.getTag(ZoomPhotoView.class);
    private static final String STATE_DISPLAY_MATRIX = "state_display_matrix";
    private static final float MIN_SCALE_EPSILON = 0.1f;
    private boolean mZoomed = false;
    private OnZoomChangeListener mZoomChangeListener;
    private PhotoView.OnMatrixChangedListener mMatrixChangedListener;

    public ZoomPhotoView(Context context) {
        super(context);
        this.init();
    }

    public ZoomPhotoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ZoomPhotoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        super.setOnMatrixChangeListener(this);
    }

    @Override
    public void onMatrixChanged(RectF rect) {
        float scale = this.getScale();
        boolean isMinScale = PageflipUtils.almost(scale, this.getMinimumScale(), 0.1f);
        this.setAllowParentInterceptOnEdge(isMinScale);
        if (scale > this.getMinimumScale()) {
            if (isMinScale && this.mZoomed) {
                this.zoomChange(false);
            } else if (!this.mZoomed && !isMinScale) {
                this.zoomChange(true);
            }
        }
        if (this.mMatrixChangedListener != null) {
            this.mMatrixChangedListener.onMatrixChanged(rect);
        }
    }

    private void zoomChange(boolean isZoomed) {
        this.mZoomed = isZoomed;
        if (this.mZoomChangeListener != null) {
            this.mZoomChangeListener.onZoomChange(isZoomed);
        }
    }

    @Override
    public void setOnMatrixChangeListener(PhotoView.OnMatrixChangedListener listener) {
        this.mMatrixChangedListener = listener;
    }

    public void setOnZoomListener(OnZoomChangeListener l) {
        this.mZoomChangeListener = l;
    }

    public boolean isZoomed() {
        return this.mZoomed;
    }

    public Bitmap getBitmap() {
        BitmapDrawable d = (BitmapDrawable)this.getDrawable();
        if (d != null) {
            return d.getBitmap();
        }
        return null;
    }

    public boolean isBitmapValid() {
        return this.isBitmapValid(this.getBitmap());
    }

    private boolean isBitmapValid(Bitmap b) {
        return b != null && !b.isRecycled();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isBitmapValid()) {
            super.onDraw(canvas);
        }
    }

    public void resetScale() {
        if (this.getScale() != this.getMinimumScale()) {
            this.setScale(this.getMinimumScale());
        }
    }

    public void recycle() {
        Bitmap b = this.getBitmap();
        if (this.isBitmapValid(b)) {
            this.resetScale();
            b.recycle();
            b = null;
            super.setImageBitmap(null);
        }
    }

    public void setImageBitmap(Bitmap bm) {
        Bitmap b = this.getBitmap();
        boolean valid = this.isBitmapValid(b);
        float[] mMatrixValues = new float[9];
        if (valid) {
            this.getSupportMatrix().getValues(mMatrixValues);
        }
        super.setOnMatrixChangeListener(null);
        super.setImageBitmap(bm);
        super.setOnMatrixChangeListener(this);
        if (valid) {
            this.getSupportMatrix().setValues(mMatrixValues);
            this.setImageMatrix(this.getDisplayMatrix());
        }
    }

    public static interface OnZoomChangeListener {
        public void onZoomChange(boolean var1);
    }
}

