/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.stats.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.pageflip.stats.StatDelivery;
import org.json.JSONObject;

public class StatDeliveryImpl
implements StatDelivery {
    public static final String TAG = Constants.getTag(StatDeliveryImpl.class);
    private ShopGun mShopgun;
    private boolean mDebug = false;

    public StatDeliveryImpl(ShopGun sgn) {
        this(sgn, false);
    }

    public StatDeliveryImpl(ShopGun sgn, boolean debug) {
        this.mShopgun = sgn;
        this.mDebug = debug;
    }

    @Override
    public boolean deliver(final String url, final JSONObject data) {
        JsonObjectRequest r = new JsonObjectRequest(Request.Method.POST, url, data, new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                StatDeliveryImpl.this.print(url, data, response, error);
            }
        });
        this.mShopgun.add(r);
        return true;
    }

    private void print(String url, JSONObject data, JSONObject response, ShopGunError error) {
        if (this.mDebug) {
            String status = response != null ? "OK" : "FAILED";
            String text = String.format("Collect[ status:%s url:%s, data:%s]", status, url, data.toString());
            SgnLog.d(TAG, text);
        }
    }
}

