/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.impl;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Hotspot;
import com.shopgun.android.sdk.pageflip.OnDrawPage;
import java.util.List;

public class OnDrawDebugPage
implements OnDrawPage {
    public static final String TAG = Constants.getTag(OnDrawDebugPage.class);

    @Override
    public Bitmap onDraw(Catalog catalog, int page, int[] pages, Bitmap b) {
        List<Hotspot> hotspots = catalog.getHotspots().get(page);
        if (hotspots != null && !hotspots.isEmpty()) {
            if (!b.isMutable()) {
                Bitmap tmp = b.copy(Bitmap.Config.RGB_565, true);
                b.recycle();
                b = tmp;
            }
            Canvas c = new Canvas(b);
            Paint p = new Paint();
            p.setStyle(Paint.Style.STROKE);
            p.setStrokeWidth(5.0f);
            for (Hotspot h : hotspots) {
                if (!h.isAreaSignificant(pages)) continue;
                p.setColor(h.getColor());
                c.drawRect(h.getRect(b), p);
            }
        }
        return b;
    }
}

